/*
 * Decompiled with CFR 0.152.
 */
package com.gravitlauncher.socketbridge.server;

import com.gravitlauncher.socketbridge.ErrorResponse;
import com.gravitlauncher.socketbridge.MessageHeader;
import com.gravitlauncher.socketbridge.Registry;
import com.gravitlauncher.socketbridge.client.SocketClient;
import com.gravitlauncher.socketbridge.server.AbstractServer;
import com.gravitlauncher.socketbridge.server.AbstractServer$ServerClient;
import com.gravitlauncher.socketbridge.server.AbstractServer$ServerHandler;
import com.gravitlauncher.socketbridge.server.SocketServer$ServerSocketClient;
import com.gravitlauncher.socketbridge.utils.ThreadUtils;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SocketServer
extends AbstractServer
implements AutoCloseable {
    private final ServerSocket socket;
    private final Thread acceptThread;
    private final Set<SocketClient> clients = ConcurrentHashMap.newKeySet();
    private final Map<String, AbstractServer$ServerHandler> handlers = new ConcurrentHashMap<String, AbstractServer$ServerHandler>();

    public SocketServer(Registry registry, Registry registry2, ServerSocket serverSocket) {
        super(registry, registry2);
        this.socket = serverSocket;
        this.acceptThread = ThreadUtils.DAEMON_THREAD_FACTORY.newThread(this::runAcceptThread);
        this.acceptThread.start();
    }

    public SocketServer(Registry registry, Registry registry2, SocketAddress socketAddress) {
        super(registry, registry2);
        this.socket = new ServerSocket();
        this.socket.bind(socketAddress);
        this.acceptThread = ThreadUtils.DAEMON_THREAD_FACTORY.newThread(this::runAcceptThread);
        this.acceptThread.start();
    }

    private void runAcceptThread() {
        while (!Thread.interrupted()) {
            try {
                Socket socket = this.socket.accept();
                if (!this.isAllowConnection(socket)) {
                    socket.close();
                }
                SocketServer$ServerSocketClient socketServer$ServerSocketClient = new SocketServer$ServerSocketClient(this, this.registryRequest, this.registryResponse, socket);
                this.clients.add(socketServer$ServerSocketClient);
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    protected boolean isAllowConnection(Socket socket) {
        return true;
    }

    @Override
    public void registerHandler(String string, AbstractServer$ServerHandler abstractServer$ServerHandler) {
        this.handlers.put(string, abstractServer$ServerHandler);
    }

    @Override
    public void unregisterHandler(String string) {
        this.handlers.remove(string);
    }

    @Override
    public void process(MessageHeader messageHeader, Object object, AbstractServer$ServerClient abstractServer$ServerClient) {
        AbstractServer$ServerHandler abstractServer$ServerHandler = this.handlers.get(messageHeader.name());
        if (abstractServer$ServerHandler != null) {
            try {
                abstractServer$ServerHandler.process(messageHeader, object, abstractServer$ServerClient);
            }
            catch (Throwable throwable) {
                abstractServer$ServerClient.sendResponse(messageHeader, new ErrorResponse(throwable.getMessage()));
            }
        }
    }

    @Override
    public void close() {
        for (SocketClient socketClient : this.clients) {
            if (!socketClient.isAlive()) continue;
            socketClient.close();
        }
        if (!this.socket.isClosed()) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

