/*
 * Decompiled with CFR 0.152.
 */
package tv.soaryn.xycraft.core;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.core.IdMapper;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.registries.GameData;
import org.jetbrains.annotations.Nullable;
import tv.soaryn.xycraft.compat.framedblocks.FramedBlocksPlugin;
import tv.soaryn.xycraft.core.XyCraft;
import tv.soaryn.xycraft.core.config.CoreClientConfig;
import tv.soaryn.xycraft.core.config.CoreServerConfig;
import tv.soaryn.xycraft.core.content.CompatContent;
import tv.soaryn.xycraft.core.content.registries.CoreAttachments;
import tv.soaryn.xycraft.core.content.registries.CoreCommands;
import tv.soaryn.xycraft.core.content.registries.CoreContent;
import tv.soaryn.xycraft.core.content.registries.CoreItemDataComponents;
import tv.soaryn.xycraft.core.content.registries.CoreStages;
import tv.soaryn.xycraft.core.content.registries.CoreSystems;
import tv.soaryn.xycraft.core.imc.IMCRegistries;
import tv.soaryn.xycraft.core.network.NetworkHandler;
import tv.soaryn.xycraft.core.network.packets.CBPlayerColorSyncPacket;
import tv.soaryn.xycraft.core.network.packets.CBRainShieldBlockPacket;
import tv.soaryn.xycraft.core.network.packets.CBStageSyncPacket;
import tv.soaryn.xycraft.core.network.packets.SBGhostSlotClickPacket;
import tv.soaryn.xycraft.core.network.packets.SBGhostSlotScrollPacket;
import tv.soaryn.xycraft.core.network.packets.SBGhostSlotSetPacket;
import tv.soaryn.xycraft.core.network.packets.SBMenuComponentMessagePacket;
import tv.soaryn.xycraft.core.network.packets.SBModifierKeyPacket;
import tv.soaryn.xycraft.core.network.packets.SBPlayerColorChangePacket;
import tv.soaryn.xycraft.core.utils.StreamUtils;
import tv.soaryn.xycraft.core.utils.rules.CoreRules;

@Mod(value="xycraft_core")
public class XyCore
extends XyCraft {
    public static final String ModId = "xycraft_core";
    public static final BlockCapability<IEnergyStorage, @Nullable Direction> BLOCK = BlockCapability.createSided((ResourceLocation)XyCore.resource("custom_energy"), IEnergyStorage.class);
    public static final NetworkHandler Network = NetworkHandler.builder("xycraft_core", "1.0.0").register("ghost_slot_click", SBGhostSlotClickPacket.class, SBGhostSlotClickPacket.SerDes).register("ghost_slot_scroll", SBGhostSlotScrollPacket.class, SBGhostSlotScrollPacket.SerDes).register("ghost_slot_set", SBGhostSlotSetPacket.class, SBGhostSlotSetPacket.SerDes).register("menu_component_msg", SBMenuComponentMessagePacket.class, SBMenuComponentMessagePacket.SerDes).register("modifier_key", SBModifierKeyPacket.class, SBModifierKeyPacket.SerDes).register("player_color_sync", CBPlayerColorSyncPacket.class, CBPlayerColorSyncPacket.SerDes).register("player_color_change", SBPlayerColorChangePacket.class, SBPlayerColorChangePacket.SerDes).register("rain_shield_block", CBRainShieldBlockPacket.class, CBRainShieldBlockPacket.SerDes).register("player_stage_sync", CBStageSyncPacket.class, CBStageSyncPacket.SerDes).build();
    public static final CoreServerConfig ServerConfig = new CoreServerConfig();
    public static final CoreClientConfig ClientConfig = new CoreClientConfig();
    public static final Component Experimental = Component.translatable((String)"xycraft.warning.experimental");

    public static ResourceLocation resource(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)ModId, (String)name);
    }

    public XyCore(IEventBus bus) {
        super(bus, ClientConfig, ServerConfig, CoreRules.Instance, CoreStages.Instance, CoreAttachments.Instance, CoreSystems.Instance, CoreContent.Map, CoreItemDataComponents.Instance);
        bus.addListener(Network::setup);
        bus.addListener(IMCRegistries.Receive::onInterModProcess);
        IMCRegistries.Send.registerNoDarkmode("tv.soaryn.xycraft");
        NeoForge.EVENT_BUS.addListener(CoreCommands::registerCommands);
        CompatContent.FramedBlocks.Mod.init(bus, FramedBlocksPlugin::init);
    }

    public static void debug() {
        if (!((Boolean)XyCore.ClientConfig.ShowBlockStateCounts.get()).booleanValue()) {
            return;
        }
        IdMapper idMap = GameData.getBlockStateIDMap();
        ArrayList blockStates = new ArrayList();
        idMap.forEach(blockStates::add);
        Thread thread = new Thread(() -> StreamUtils.execute(() -> {
            Logger.debug("--------");
            List<Map.Entry> t = blockStates.parallelStream().collect(Collectors.groupingBy(state -> BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).getNamespace())).entrySet().stream().sorted(Comparator.comparingInt(o -> ((List)o.getValue()).size()).reversed()).toList();
            for (Map.Entry entry : t) {
                Logger.debug("## " + (String)entry.getKey() + " : " + ((List)entry.getValue()).size());
                List<Map.Entry> stateGroup = ((List)entry.getValue()).stream().collect(Collectors.groupingBy(BlockBehaviour.BlockStateBase::getBlock)).entrySet().stream().sorted(Comparator.comparingInt(o -> ((List)o.getValue()).size()).reversed()).toList();
                for (Map.Entry stateEntry : stateGroup) {
                    Logger.debug("- " + ((Block)stateEntry.getKey()).getDescriptionId() + " : " + ((List)stateEntry.getValue()).size());
                }
            }
            Logger.debug("--------");
        }));
        thread.setName("DebugStates");
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

