/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.shadow.fablabsmc.fablabs.impl.fiber.constraint;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.schema.type.RecordSerializableType;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.schema.type.SerializableType;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.schema.type.TypeCheckResult;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.impl.fiber.constraint.ConstraintChecker;

public class RecordConstraintChecker
extends ConstraintChecker<Map<String, Object>, RecordSerializableType> {
    private static final RecordConstraintChecker INSTANCE = new RecordConstraintChecker();

    public static RecordConstraintChecker instance() {
        return INSTANCE;
    }

    private RecordConstraintChecker() {
    }

    @Override
    public TypeCheckResult<Map<String, Object>> test(RecordSerializableType cfg, Map<String, Object> value) {
        if (!value.keySet().containsAll(cfg.getFields().keySet())) {
            return TypeCheckResult.unrecoverable();
        }
        boolean successful = cfg.getFields().keySet().containsAll(value.keySet());
        LinkedHashMap corrected = new LinkedHashMap(value.size());
        for (Map.Entry<String, SerializableType<?>> field : cfg.getFields().entrySet()) {
            Object child = value.get(field.getKey());
            SerializableType<?> fieldType = field.getValue();
            TypeCheckResult<?> result = this.testChild(fieldType, child);
            Optional<?> correctedFieldValue = result.getCorrectedValue();
            if (!result.hasPassed()) {
                successful = false;
            }
            if (correctedFieldValue.isPresent()) {
                corrected.put(field.getKey(), correctedFieldValue.get());
                continue;
            }
            return TypeCheckResult.unrecoverable();
        }
        return successful ? TypeCheckResult.successful(value) : TypeCheckResult.failed(corrected);
    }

    private <T> TypeCheckResult<T> testChild(SerializableType<T> type, Object value) {
        return type.test(value);
    }

    @Override
    public boolean comprehends(RecordSerializableType cfg, RecordSerializableType cfg2) {
        for (Map.Entry<String, SerializableType<?>> entry : cfg.getFields().entrySet()) {
            SerializableType<?> other = cfg2.getFields().get(entry.getKey());
            if (entry.getValue().equals(other)) continue;
            return false;
        }
        return true;
    }
}

