/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.shadow.fablabsmc.fablabs.impl.fiber.constraint;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.schema.type.ListSerializableType;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.schema.type.TypeCheckResult;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.impl.fiber.constraint.ConstraintChecker;

public final class ListConstraintChecker<E>
extends ConstraintChecker<List<E>, ListSerializableType<E>> {
    private static final ListConstraintChecker<?> INSTANCE = new ListConstraintChecker();

    public static <E> ListConstraintChecker<E> instance() {
        ListConstraintChecker<?> t = INSTANCE;
        return t;
    }

    private ListConstraintChecker() {
    }

    @Override
    public TypeCheckResult<List<E>> test(ListSerializableType<E> cfg, List<E> values) {
        boolean valid = true;
        int maxSize = cfg.getMaxSize();
        AbstractCollection corrected = cfg.hasUniqueElements() ? new LinkedHashSet(values.size()) : new ArrayList(values.size());
        for (E e : values) {
            if (corrected.size() >= maxSize) {
                valid = false;
                break;
            }
            TypeCheckResult<E> testResult = cfg.getElementType().test(e);
            if (testResult.hasPassed()) {
                valid &= corrected.add(e);
                continue;
            }
            valid = false;
            Optional<E> correctedValue = testResult.getCorrectedValue();
            correctedValue.ifPresent(corrected::add);
        }
        if (corrected.size() < cfg.getMinSize()) {
            return TypeCheckResult.unrecoverable();
        }
        return valid ? TypeCheckResult.successful(values) : TypeCheckResult.failed(new ArrayList(corrected));
    }

    @Override
    public boolean comprehends(ListSerializableType<E> cfg, ListSerializableType<E> cfg2) {
        if (cfg.getMinSize() > cfg2.getMinSize()) {
            return false;
        }
        if (cfg.getMaxSize() < cfg2.getMaxSize()) {
            return false;
        }
        if (!cfg.getElementType().isAssignableFrom(cfg2.getElementType())) {
            return false;
        }
        return !cfg.hasUniqueElements() || cfg2.hasUniqueElements();
    }
}

