/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.shadow.fablabsmc.fablabs.impl.fiber.builder;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.FiberId;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.schema.type.SerializableType;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.tree.ConfigAttribute;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.tree.ConfigNode;
import me.drex.villagerconfig.shadow.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;

public abstract class ConfigNodeBuilder {
    @Nullable
    protected ConfigTree parent;
    @Nullable
    protected String name;
    @Nullable
    protected String comment = null;
    protected Map<FiberId, ConfigAttribute<?>> attributes;

    public ConfigNodeBuilder(@Nullable ConfigTree parent, @Nullable String name) {
        if (parent != null && name == null) {
            throw new IllegalArgumentException("A child node needs a name");
        }
        this.parent = parent;
        this.name = name;
        this.attributes = new HashMap();
    }

    public ConfigNodeBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public ConfigNodeBuilder withComment(String comment) {
        this.comment = comment;
        return this;
    }

    public <A> ConfigNodeBuilder withAttribute(FiberId id, SerializableType<A> type, A defaultValue) {
        return this.withAttribute(ConfigAttribute.create(id, type, defaultValue));
    }

    public ConfigNodeBuilder withAttributes(Collection<ConfigAttribute<?>> attributes) {
        for (ConfigAttribute<?> attribute : attributes) {
            this.withAttribute(attribute);
        }
        return this;
    }

    public ConfigNodeBuilder withAttribute(ConfigAttribute<?> attribute) {
        this.attributes.put(attribute.getIdentifier(), attribute);
        return this;
    }

    public abstract ConfigNode build();
}

