/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.util;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntUnaryOperator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.drex.villagerconfig.common.data.BehaviorTrade;
import me.drex.villagerconfig.common.data.TradeGroup;
import me.drex.villagerconfig.common.data.TradeTable;
import me.drex.villagerconfig.common.data.TradeTier;
import me.drex.villagerconfig.common.mixin.VillagerDataAccessor;
import me.drex.villagerconfig.common.util.loot.function.EnchantRandomlyLootFunction;
import me.drex.villagerconfig.common.util.loot.function.SetDyeFunction;
import me.drex.villagerconfig.common.util.loot.number.AddLootNumberProvider;
import me.drex.villagerconfig.common.util.loot.number.MultiplyLootNumberProvider;
import me.drex.villagerconfig.common.util.loot.number.ReferenceLootNumberProvider;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.providers.EnchantmentProvider;
import net.minecraft.world.item.enchantment.providers.SingleEnchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.EntryGroup;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.EnchantWithLevelsFunction;
import net.minecraft.world.level.storage.loot.functions.ExplorationMapFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetEnchantmentsFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNameFunction;
import net.minecraft.world.level.storage.loot.functions.SetPotionFunction;
import net.minecraft.world.level.storage.loot.functions.SetStewEffectFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class TradeProvider
implements DataProvider {
    private final PackOutput.PathProvider pathResolver;
    private final CompletableFuture<HolderLookup.Provider> registries;
    private final boolean experimental;
    private final PotionBrewing potionBrewing;
    public static final ResourceLocation WANDERING_TRADER_ID = ResourceLocation.withDefaultNamespace((String)"wanderingtrader");
    private static final IntUnaryOperator EXPERIMENTAL1_21_4_WANDERING_TRADER_COUNT = i -> {
        List trades = VillagerTrades.EXPERIMENTAL_WANDERING_TRADER_TRADES;
        if (i > trades.size()) {
            return 0;
        }
        return (Integer)((Pair)trades.get(i - 1)).getValue();
    };
    private static final IntUnaryOperator WANDERING_TRADER_COUNT = i -> switch (i) {
        case 1 -> 5;
        case 2 -> 1;
        default -> 0;
    };

    public TradeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, boolean experimental, FeatureFlagSet featureFlags) {
        this.pathResolver = output.createPathProvider(PackOutput.Target.DATA_PACK, "trades");
        this.registries = registries;
        this.experimental = experimental;
        this.potionBrewing = PotionBrewing.bootstrap((FeatureFlagSet)featureFlags);
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput writer) {
        return this.registries.thenCompose(provider -> this.run(writer, (HolderLookup.Provider)provider));
    }

    @NotNull
    public CompletableFuture<?> run(@NotNull CachedOutput writer, HolderLookup.Provider provider) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry2 : BuiltInRegistries.VILLAGER_PROFESSION.entrySet()) {
            ResourceKey key = (ResourceKey)entry2.getKey();
            VillagerProfession tradeKey = (VillagerProfession)entry2.getValue();
            Int2ObjectMap trades = (Int2ObjectMap)VillagerTrades.TRADES.getOrDefault(tradeKey, new Int2ObjectArrayMap());
            Int2ObjectMap experimentalTrades = (Int2ObjectMap)VillagerTrades.EXPERIMENTAL_TRADES.get(tradeKey);
            if (this.experimental && experimentalTrades != null) {
                trades = experimentalTrades;
            }
            map.put(key.location(), new TradeData((Int2ObjectMap<VillagerTrades.ItemListing[]>)trades, OfferCountType.VILLAGER, true));
        }
        if (this.experimental) {
            Int2ObjectArrayMap experimentalTrades = new Int2ObjectArrayMap();
            List experimentalWanderingTraderTrades = VillagerTrades.EXPERIMENTAL_WANDERING_TRADER_TRADES;
            for (int i = 0; i < experimentalWanderingTraderTrades.size(); ++i) {
                Pair pair = (Pair)experimentalWanderingTraderTrades.get(i);
                experimentalTrades.put(i + 1, (Object)((VillagerTrades.ItemListing[])pair.getLeft()));
            }
            map.put(WANDERING_TRADER_ID, new TradeData((Int2ObjectMap<VillagerTrades.ItemListing[]>)experimentalTrades, OfferCountType.EXPERIMENTAL_WANDERING_TRADER, false));
        } else {
            map.put(WANDERING_TRADER_ID, new TradeData((Int2ObjectMap<VillagerTrades.ItemListing[]>)VillagerTrades.WANDERING_TRADER_TRADES, OfferCountType.WANDERING_TRADER, false));
        }
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> {
            TradeTier[] tiers;
            ResourceLocation id = (ResourceLocation)entry.getKey();
            TradeData tradeData = (TradeData)entry.getValue();
            Path path = this.pathResolver.json(id);
            int maxLevel = 0;
            while (tradeData.trades().containsKey(maxLevel + 1)) {
                ++maxLevel;
            }
            TradeGroup[] tradeGroups = new TradeGroup[maxLevel];
            tradeData.trades().forEach((level, factoryArr) -> {
                TradeGroup tradeGroup;
                if (level <= 0 || level > tradeGroups.length) {
                    LOGGER.warn("Invalid trade level {}, expected 1 - {}, for villager type {}", new Object[]{level, tradeGroups.length, id});
                    return;
                }
                tradeGroups[level.intValue() - 1] = tradeGroup = new TradeGroup((NumberProvider)ConstantValue.exactly((float)tradeData.offerCountType().getOfferCount((int)level)), Arrays.stream(factoryArr).map(itemListing -> this.convert((VillagerTrades.ItemListing)itemListing, id, provider)).flatMap(Stream::of).map(BehaviorTrade.Builder::build).filter(Objects::nonNull).toList());
            });
            if (tradeData.useTiers()) {
                tiers = new TradeTier[maxLevel];
                for (int i = 0; i < tradeGroups.length; ++i) {
                    tiers[i] = new TradeTier(VillagerDataAccessor.getNextLevelXpThresholds()[i], List.of(tradeGroups[i]));
                }
            } else {
                tiers = new TradeTier[]{new TradeTier(0, List.of(tradeGroups))};
            }
            TradeTable tradeTable = new TradeTable(List.of(tiers));
            return DataProvider.saveStable((CachedOutput)writer, (HolderLookup.Provider)provider, TradeTable.CODEC, (Object)tradeTable, (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    @NotNull
    public String getName() {
        return "Trades";
    }

    private BehaviorTrade.Builder[] convert(VillagerTrades.ItemListing original, ResourceLocation id, HolderLookup.Provider provider) {
        if (original instanceof VillagerTrades.EmeraldForItems) {
            VillagerTrades.EmeraldForItems factory = (VillagerTrades.EmeraldForItems)original;
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((LootPoolEntryContainer.Builder<?>)TradeProvider.lootTableItemStack(factory.itemStack.itemStack()), (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)Items.EMERALD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)factory.emeraldAmount)))).priceMultiplier(factory.priceMultiplier).traderExperience(factory.villagerXp).maxUses(factory.maxUses)};
        }
        if (original instanceof VillagerTrades.ItemsForEmeralds) {
            VillagerTrades.ItemsForEmeralds factory = (VillagerTrades.ItemsForEmeralds)original;
            LootPoolSingletonContainer.Builder<?> result = TradeProvider.lootTableItemStack(factory.itemStack);
            this.enchantItem(result, factory.enchantmentProvider, (VillagerTrades.ItemListing)factory, provider);
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)Items.EMERALD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)factory.emeraldCost))), (LootPoolEntryContainer.Builder<?>)result).priceMultiplier(factory.priceMultiplier).traderExperience(factory.villagerXp).maxUses(factory.maxUses)};
        }
        if (original instanceof VillagerTrades.SuspiciousStewForEmerald) {
            VillagerTrades.SuspiciousStewForEmerald factory = (VillagerTrades.SuspiciousStewForEmerald)original;
            LootPoolSingletonContainer.Builder suspciousStewBuilder = LootItem.lootTableItem((ItemLike)Items.SUSPICIOUS_STEW);
            for (SuspiciousStewEffects.Entry effect : factory.effects.effects()) {
                int duration = effect.duration();
                if (!((MobEffect)effect.effect().value()).isInstantenous()) {
                    duration /= 20;
                }
                suspciousStewBuilder.apply((LootItemFunction.Builder)new SetStewEffectFunction.Builder().withEffect(effect.effect(), (NumberProvider)ConstantValue.exactly((float)duration)));
            }
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)Items.EMERALD), (LootPoolEntryContainer.Builder<?>)suspciousStewBuilder).traderExperience(factory.xp)};
        }
        if (original instanceof VillagerTrades.ItemsAndEmeraldsToItems) {
            VillagerTrades.ItemsAndEmeraldsToItems factory = (VillagerTrades.ItemsAndEmeraldsToItems)original;
            LootPoolSingletonContainer.Builder<?> result = TradeProvider.lootTableItemStack(factory.toItem);
            this.enchantItem(result, factory.enchantmentProvider, (VillagerTrades.ItemListing)factory, provider);
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)Items.EMERALD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)factory.emeraldCost))), (LootPoolEntryContainer.Builder<?>)TradeProvider.lootTableItemStack(factory.fromItem.itemStack()), (LootPoolEntryContainer.Builder<?>)result).priceMultiplier(factory.priceMultiplier).traderExperience(factory.villagerXp).maxUses(factory.maxUses)};
        }
        if (original instanceof VillagerTrades.EnchantedItemForEmeralds) {
            VillagerTrades.EnchantedItemForEmeralds factory = (VillagerTrades.EnchantedItemForEmeralds)original;
            Optional optional = provider.lookupOrThrow(Registries.ENCHANTMENT).get(EnchantmentTags.ON_TRADED_EQUIPMENT);
            EnchantWithLevelsFunction.Builder builder = new EnchantWithLevelsFunction.Builder((NumberProvider)ReferenceLootNumberProvider.create("enchantLevel"));
            optional.ifPresent(arg_0 -> ((EnchantWithLevelsFunction.Builder)builder).fromOptions(arg_0));
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)Items.EMERALD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)factory.baseEmeraldCost))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ReferenceLootNumberProvider.create("enchantLevel"), (boolean)true)), (LootPoolEntryContainer.Builder<?>)TradeProvider.lootTableItemStack(factory.itemStack).apply((LootItemFunction.Builder)builder)).priceMultiplier(factory.priceMultiplier).traderExperience(factory.villagerXp).maxUses(factory.maxUses).numberReference("enchantLevel", (NumberProvider)UniformGenerator.between((float)5.0f, (float)19.0f))};
        }
        if (original instanceof VillagerTrades.EmeraldsForVillagerTypeItem) {
            VillagerTrades.EmeraldsForVillagerTypeItem factory = (VillagerTrades.EmeraldsForVillagerTypeItem)original;
            ArrayList<BehaviorTrade.Builder> trades = new ArrayList<BehaviorTrade.Builder>(factory.trades.size());
            for (Map.Entry entry : TradeProvider.sortedEntrySet(factory.trades.entrySet())) {
                CompoundTag root = new CompoundTag();
                CompoundTag villagerData = new CompoundTag();
                villagerData.putString("type", BuiltInRegistries.VILLAGER_TYPE.getKey((Object)entry.getKey()).toString());
                root.put("VillagerData", (Tag)villagerData);
                BehaviorTrade.Builder trade = new BehaviorTrade.Builder((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)((ItemLike)factory.trades.get(entry.getKey()))).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)factory.cost))), (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)Items.EMERALD)).priceMultiplier(0.05f).traderExperience(factory.villagerXp).maxUses(factory.maxUses).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().nbt(new NbtPredicate(root))));
                trades.add(trade);
            }
            return (BehaviorTrade.Builder[])trades.toArray(BehaviorTrade.Builder[]::new);
        }
        if (original instanceof VillagerTrades.TippedArrowForItemsAndEmeralds) {
            VillagerTrades.TippedArrowForItemsAndEmeralds factory = (VillagerTrades.TippedArrowForItemsAndEmeralds)original;
            List potions = BuiltInRegistries.POTION.holders().filter(reference -> !((Potion)reference.value()).getEffects().isEmpty() && this.potionBrewing.isBrewablePotion((Holder)reference)).collect(Collectors.toList());
            LootPoolEntryContainer.Builder[] entries = new LootPoolEntryContainer.Builder[potions.size()];
            for (int i = 0; i < potions.size(); ++i) {
                Holder potion = (Holder)potions.get(i);
                entries[i] = TradeProvider.lootTableItemStack(factory.toItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)factory.toCount))).apply((LootItemFunction.Builder)SetPotionFunction.setPotion((Holder)potion));
            }
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)Items.EMERALD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)factory.emeraldCost))), (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)factory.fromItem).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)factory.fromCount))), (LootPoolEntryContainer.Builder<?>)EntryGroup.list((LootPoolEntryContainer.Builder[])entries)).priceMultiplier(factory.priceMultiplier).traderExperience(factory.villagerXp).maxUses(factory.maxUses)};
        }
        if (original instanceof VillagerTrades.EnchantBookForEmeralds) {
            VillagerTrades.EnchantBookForEmeralds factory = (VillagerTrades.EnchantBookForEmeralds)original;
            EnchantRandomlyLootFunction.Builder enchantRandomlyFunction = new EnchantRandomlyLootFunction.Builder().minLevel(factory.minLevel).maxLevel(factory.maxLevel).include((HolderSet<Enchantment>)provider.lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(factory.tradeableEnchantments));
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)Items.EMERALD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)MultiplyLootNumberProvider.create(AddLootNumberProvider.create(new NumberProvider[]{ConstantValue.exactly((float)2.0f), new UniformGenerator((NumberProvider)ConstantValue.exactly((float)0.0f), (NumberProvider)AddLootNumberProvider.create(new NumberProvider[]{ConstantValue.exactly((float)5.0f), MultiplyLootNumberProvider.create(new NumberProvider[]{ReferenceLootNumberProvider.create("enchantmentLevel"), ConstantValue.exactly((float)10.0f)})})), MultiplyLootNumberProvider.create(new NumberProvider[]{ConstantValue.exactly((float)3.0f), ReferenceLootNumberProvider.create("enchantmentLevel")})}), ReferenceLootNumberProvider.create("treasureMultiplier")))), (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)Items.BOOK), (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)Items.BOOK).apply((LootItemFunction.Builder)enchantRandomlyFunction)).traderExperience(factory.villagerXp)};
        }
        if (original instanceof VillagerTrades.TreasureMapForEmeralds) {
            VillagerTrades.TreasureMapForEmeralds factory = (VillagerTrades.TreasureMapForEmeralds)original;
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)Items.EMERALD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)factory.emeraldCost))), (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)Items.COMPASS), (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)Items.MAP).apply((LootItemFunction.Builder)new ExplorationMapFunction.Builder().setSearchRadius(100).setMapDecoration(factory.destinationType).setDestination(factory.destination).setZoom((byte)2).setSkipKnownStructures(true)).apply((LootItemFunction.Builder)SetNameFunction.setName((Component)Component.translatable((String)factory.displayName), (SetNameFunction.Target)SetNameFunction.Target.ITEM_NAME))).traderExperience(factory.villagerXp).maxUses(factory.maxUses)};
        }
        if (original instanceof VillagerTrades.DyedArmorForEmeralds) {
            VillagerTrades.DyedArmorForEmeralds factory = (VillagerTrades.DyedArmorForEmeralds)original;
            return new BehaviorTrade.Builder[]{new BehaviorTrade.Builder((LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)Items.EMERALD).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)factory.value))), (LootPoolEntryContainer.Builder<?>)LootItem.lootTableItem((ItemLike)factory.item).apply((LootItemFunction.Builder)new SetDyeFunction.Builder(true)).apply((LootItemFunction.Builder)new SetDyeFunction.Builder(true).when(LootItemRandomChanceCondition.randomChance((float)0.3f))).apply((LootItemFunction.Builder)new SetDyeFunction.Builder(true).when(LootItemRandomChanceCondition.randomChance((float)0.2f)))).traderExperience(factory.villagerXp).maxUses(factory.maxUses)};
        }
        if (original instanceof VillagerTrades.TypeSpecificTrade) {
            VillagerTrades.TypeSpecificTrade factory = (VillagerTrades.TypeSpecificTrade)original;
            ArrayList<BehaviorTrade.Builder> trades = new ArrayList<BehaviorTrade.Builder>(factory.trades().size());
            for (Map.Entry entry : TradeProvider.sortedEntrySet(factory.trades().entrySet())) {
                CompoundTag root = new CompoundTag();
                CompoundTag villagerData = new CompoundTag();
                villagerData.putString("type", BuiltInRegistries.VILLAGER_TYPE.getKey((Object)entry.getKey()).toString());
                root.put("VillagerData", (Tag)villagerData);
                for (BehaviorTrade.Builder behaviorTrade : this.convert((VillagerTrades.ItemListing)entry.getValue(), id, provider)) {
                    behaviorTrade.when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().nbt(new NbtPredicate(root))));
                    trades.add(behaviorTrade);
                }
            }
            return (BehaviorTrade.Builder[])trades.toArray(BehaviorTrade.Builder[]::new);
        }
        LOGGER.warn("Unable to convert {}: {} for {}, generated json won't be complete!", new Object[]{original.getClass(), original, id});
        return new BehaviorTrade.Builder[0];
    }

    private void enchantItem(LootPoolSingletonContainer.Builder<?> builder, Optional<ResourceKey<EnchantmentProvider>> optional, VillagerTrades.ItemListing factory, HolderLookup.Provider provider) {
        if (optional.isPresent()) {
            SingleEnchantment singleEnchantment;
            IntProvider intProvider;
            EnchantmentProvider enchantmentProvider = (EnchantmentProvider)provider.lookupOrThrow(Registries.ENCHANTMENT_PROVIDER).getOrThrow(optional.get()).value();
            if (enchantmentProvider instanceof SingleEnchantment && (intProvider = (singleEnchantment = (SingleEnchantment)enchantmentProvider).level()) instanceof ConstantInt) {
                ConstantInt constantInt = (ConstantInt)intProvider;
                builder.apply((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder().withEnchantment(singleEnchantment.enchantment(), (NumberProvider)new ConstantValue((float)constantInt.getValue())));
            } else {
                LOGGER.warn("Failed to generate trades '{}', encountered unexpected enchantment provider '{}'.", (Object)factory, (Object)enchantmentProvider);
            }
        }
    }

    private static <T> List<Map.Entry<VillagerType, T>> sortedEntrySet(Set<Map.Entry<VillagerType, T>> entrySet) {
        return entrySet.stream().sorted(Comparator.comparing(o -> ((VillagerType)o.getKey()).toString())).toList();
    }

    private static LootPoolSingletonContainer.Builder<?> lootTableItemStack(ItemStack itemStack) {
        LootPoolSingletonContainer.Builder builder = LootItem.lootTableItem((ItemLike)itemStack.getItem());
        if (itemStack.getCount() != 1) {
            builder.apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)itemStack.getCount())));
        }
        ItemEnchantments enchantments = (ItemEnchantments)itemStack.getOrDefault(DataComponents.ENCHANTMENTS, (Object)ItemEnchantments.EMPTY);
        enchantments.entrySet().forEach(holderEntry -> builder.apply((LootItemFunction.Builder)new SetEnchantmentsFunction.Builder(true).withEnchantment((Holder)holderEntry.getKey(), (NumberProvider)ConstantValue.exactly((float)holderEntry.getIntValue()))));
        PotionContents potionContents = (PotionContents)itemStack.getOrDefault(DataComponents.POTION_CONTENTS, (Object)PotionContents.EMPTY);
        potionContents.potion().ifPresent(potionHolder -> builder.apply((LootItemFunction.Builder)SetPotionFunction.setPotion((Holder)potionHolder)));
        return builder;
    }

    public record TradeData(Int2ObjectMap<VillagerTrades.ItemListing[]> trades, OfferCountType offerCountType, boolean useTiers) {
    }

    public static enum OfferCountType {
        VILLAGER(i -> 2),
        WANDERING_TRADER(WANDERING_TRADER_COUNT),
        EXPERIMENTAL_WANDERING_TRADER(EXPERIMENTAL1_21_4_WANDERING_TRADER_COUNT);

        private final IntUnaryOperator operator;

        private OfferCountType(IntUnaryOperator operator) {
            this.operator = operator;
        }

        public int getOfferCount(int level) {
            return this.operator.apply(level);
        }
    }
}

