/*
 * Decompiled with CFR 0.152.
 */
package me.drex.villagerconfig.common.mixin;

import me.drex.villagerconfig.common.data.TradeTable;
import me.drex.villagerconfig.common.util.CustomVillagerData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager {
    @Shadow
    public abstract VillagerData getVillagerData();

    public VillagerMixin(EntityType<? extends AbstractVillager> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"updateTrades"}, at={@At(value="HEAD")}, cancellable=true)
    public void putCustomTrades(CallbackInfo ci) {
        TradeTable tradeTable = CustomVillagerData.getTradeTable((Villager)this);
        if (tradeTable != null) {
            VillagerData villagerData = this.getVillagerData();
            int level = villagerData.getLevel();
            VillagerTrades.ItemListing[] tradeOffers = tradeTable.getTradeOffers(this, level);
            MerchantOffers tradeOfferList = this.getOffers();
            for (VillagerTrades.ItemListing tradeOffer : tradeOffers) {
                tradeOfferList.add((Object)tradeOffer.getOffer((Entity)this, this.random));
            }
            ci.cancel();
        }
    }

    @Redirect(method={"shouldIncreaseLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/npc/VillagerData;canLevelUp(I)Z"))
    public boolean adjustMaxLevel(int level) {
        return CustomVillagerData.canLevelUp((Villager)this, level);
    }

    @Redirect(method={"shouldIncreaseLevel"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/npc/VillagerData;getMaxXpPerLevel(I)I"))
    public int adjustUpperLevelExperience(int level) {
        return CustomVillagerData.getMaxXpPerLevel((Villager)this, level);
    }
}

