/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay.main;

import com.dooji.underlay.main.UnderlayApi;
import com.dooji.underlay.main.UnderlayManager;
import com.dooji.underlay.main.events.BlockInteractionEvents;
import com.dooji.underlay.main.events.PlayerEvents;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="underlay")
public class Underlay {
    public static final String MOD_ID = "underlay";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"underlay");
    private static final TagKey<Block> OVERLAY_TAG = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"underlay", (String)"overlay"));
    public static final TagKey<Block> EXCLUDE_TAG = TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"underlay", (String)"exclude"));

    public Underlay() {
        NeoForge.EVENT_BUS.register((Object)this);
        NeoForge.EVENT_BUS.register((Object)new BlockInteractionEvents());
        NeoForge.EVENT_BUS.register((Object)new PlayerEvents());
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        for (ServerLevel world : event.getServer().getAllLevels()) {
            LOGGER.info("Loading overlays for world: " + String.valueOf(world.dimension().location()));
            UnderlayManager.loadOverlays((Level)world);
            Underlay.reloadDatapackBlocks(world);
        }
    }

    private static void reloadDatapackBlocks(ServerLevel world) {
        UnderlayApi.CUSTOM_BLOCKS_DP.clear();
        Registry blocks = world.registryAccess().registryOrThrow(BuiltInRegistries.BLOCK.key());
        blocks.getTag(OVERLAY_TAG).ifPresent(tag -> tag.forEach(entry -> {
            Block block = (Block)entry.value();
            if (!blocks.getOrCreateTag(EXCLUDE_TAG).contains(entry)) {
                UnderlayApi.registerDatapackOverlayBlock(block);
            }
        }));
    }
}

