/*
 * Decompiled with CFR 0.152.
 */
package com.dooji.underlay.client;

import com.dooji.underlay.client.UnderlayManagerClient;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class UnderlayRaycast {
    public static BlockHitResult trace(Entity viewer, double reach, float tickDelta) {
        Minecraft client = Minecraft.getInstance();
        Vec3 eye = viewer.getEyePosition(tickDelta);
        Vec3 look = viewer.getViewVector(tickDelta);
        Vec3 end = eye.add(look.multiply(reach, reach, reach));
        double best = Double.MAX_VALUE;
        BlockHitResult bestHit = null;
        for (BlockPos pos : UnderlayManagerClient.getAll().keySet()) {
            BlockState state;
            VoxelShape shape;
            BlockHitResult hit;
            if (pos.distSqr((Vec3i)new BlockPos((int)eye.x, (int)eye.y, (int)eye.z)) > reach * reach || (hit = (shape = (state = UnderlayManagerClient.getOverlay(pos)).getShape((BlockGetter)client.level, pos, CollisionContext.of((Entity)viewer))).clip(eye, end, pos)) == null) continue;
            Vec3 hitPos = hit.getLocation();
            double distanceSquared = hitPos.distanceToSqr(eye);
            ClipContext context = new ClipContext(eye, hitPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, viewer);
            BlockHitResult worldHit = client.level.clip(context);
            if (worldHit.getType() == HitResult.Type.BLOCK && worldHit.getLocation().distanceToSqr(eye) < distanceSquared || !(distanceSquared < best)) continue;
            best = distanceSquared;
            bestHit = hit;
        }
        return bestHit;
    }
}

