/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import twilightforest.TwilightForestMod;
import twilightforest.entity.ProtectionBox;
import twilightforest.init.TFParticleType;

public class AreaProtectionPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<AreaProtectionPacket> TYPE = new CustomPacketPayload.Type(TwilightForestMod.prefix("add_protection_box"));
    public static final StreamCodec<RegistryFriendlyByteBuf, AreaProtectionPacket> STREAM_CODEC = CustomPacketPayload.codec(AreaProtectionPacket::write, AreaProtectionPacket::new);
    private final List<BoundingBox> sbb;
    private final BlockPos pos;

    public AreaProtectionPacket(List<BoundingBox> sbb, BlockPos pos) {
        this.sbb = sbb;
        this.pos = pos;
    }

    public AreaProtectionPacket(FriendlyByteBuf buf) {
        this.sbb = new ArrayList<BoundingBox>();
        int len = buf.readInt();
        for (int i = 0; i < len; ++i) {
            this.sbb.add(new BoundingBox(buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt()));
        }
        this.pos = buf.readBlockPos();
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.sbb.size());
        this.sbb.forEach(box -> {
            buf.writeInt(box.minX());
            buf.writeInt(box.minY());
            buf.writeInt(box.minZ());
            buf.writeInt(box.maxX());
            buf.writeInt(box.maxY());
            buf.writeInt(box.maxZ());
        });
        buf.writeBlockPos(this.pos);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(final AreaProtectionPacket message, final IPayloadContext ctx) {
        if (ctx.flow().isClientbound()) {
            ctx.enqueueWork(new Runnable(){

                @Override
                public void run() {
                    ClientLevel clientLevel;
                    Level level = ctx.player().level();
                    ClientLevel level2 = level instanceof ClientLevel ? (clientLevel = (ClientLevel)level) : Minecraft.getInstance().level;
                    message.sbb.forEach(box -> {
                        for (Entity entity : level2.entitiesForRendering()) {
                            if (!(entity instanceof ProtectionBox)) continue;
                            ProtectionBox prot = (ProtectionBox)entity;
                            if (prot.lifeTime <= 0 || !prot.matches((BoundingBox)box)) continue;
                            prot.resetLifetime();
                            return;
                        }
                        level2.addEntity((Entity)new ProtectionBox((Level)level2, (BoundingBox)box));
                    });
                    for (int i = 0; i < 20; ++i) {
                        double vx = level2.getRandom().nextGaussian() * 0.02;
                        double vy = level2.getRandom().nextGaussian() * 0.02;
                        double vz = level2.getRandom().nextGaussian() * 0.02;
                        double x = (double)message.pos.getX() + 0.5 + (double)level2.getRandom().nextFloat() - (double)level2.getRandom().nextFloat();
                        double y = (double)message.pos.getY() + 0.5 + (double)level2.getRandom().nextFloat() - (double)level2.getRandom().nextFloat();
                        double z = (double)message.pos.getZ() + 0.5 + (double)level2.getRandom().nextFloat() - (double)level2.getRandom().nextFloat();
                        level2.addParticle((ParticleOptions)TFParticleType.PROTECTION.get(), x, y, z, vx, vy, vz);
                    }
                }
            });
        }
    }
}

