/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import twilightforest.block.RopeBlock;

public class RopeItem
extends BlockItem {
    public static final int EXTEND_RANGE = 7;

    public RopeItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        Level level = context.getLevel();
        BlockState blockstate = level.getBlockState(blockpos);
        if (!blockstate.is(this.getBlock())) {
            return context;
        }
        Direction direction = this.getForward(context, blockstate, blockpos, level);
        if (direction == null) {
            return null;
        }
        if (direction == Direction.UP) {
            direction = Direction.DOWN;
        }
        int i = 0;
        BlockPos.MutableBlockPos mutableBlockPos = blockpos.mutable();
        while (i < 7) {
            if (!level.isClientSide && !level.isInWorldBounds((BlockPos)mutableBlockPos)) {
                Player player = context.getPlayer();
                int j = level.getMaxBuildHeight();
                if (!(player instanceof ServerPlayer)) break;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (mutableBlockPos.getY() < j) break;
                serverPlayer.sendSystemMessage((Component)Component.translatable((String)"build.tooHigh", (Object[])new Object[]{j - 1}).withStyle(ChatFormatting.RED), true);
                break;
            }
            blockstate = level.getBlockState((BlockPos)mutableBlockPos);
            if (!blockstate.is(this.getBlock())) {
                if (!blockstate.canBeReplaced(context)) break;
                return BlockPlaceContext.at((BlockPlaceContext)context, (BlockPos)mutableBlockPos, (Direction)direction);
            }
            if (!this.stateHasValue(blockstate, direction)) {
                return BlockPlaceContext.at((BlockPlaceContext)context, (BlockPos)mutableBlockPos, (Direction)direction);
            }
            mutableBlockPos.move(direction);
            if (!direction.getAxis().isHorizontal()) continue;
            ++i;
        }
        return null;
    }

    protected boolean stateHasValue(BlockState state, Direction direction) {
        return switch (direction.getAxis()) {
            case Direction.Axis.X -> (Boolean)state.getValue((Property)RopeBlock.X);
            case Direction.Axis.Y -> (Boolean)state.getValue((Property)RopeBlock.Y);
            default -> (Boolean)state.getValue((Property)RopeBlock.Z);
        };
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        BlockPos pos;
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos = context.getClickedPos());
        if (state.is(this.getBlock())) {
            Direction direction = context.getClickedFace();
            if (direction.getAxis() == Direction.Axis.X && !((Boolean)state.getValue((Property)RopeBlock.X)).booleanValue()) {
                return (BlockState)state.setValue((Property)RopeBlock.X, (Comparable)Boolean.valueOf(true));
            }
            if (direction.getAxis() == Direction.Axis.Y && !((Boolean)state.getValue((Property)RopeBlock.Y)).booleanValue()) {
                return (BlockState)state.setValue((Property)RopeBlock.Y, (Comparable)Boolean.valueOf(true));
            }
            if (direction.getAxis() == Direction.Axis.Z && !((Boolean)state.getValue((Property)RopeBlock.Z)).booleanValue()) {
                return (BlockState)state.setValue((Property)RopeBlock.Z, (Comparable)Boolean.valueOf(true));
            }
        }
        return super.getPlacementState(context);
    }

    @Nullable
    protected Direction getForward(BlockPlaceContext context, BlockState state, BlockPos pos, Level level) {
        Direction face = context.getClickedFace();
        BlockPos relativePos = pos.relative(face);
        if (RopeBlock.canConnectTo(level.getBlockState(relativePos), face, (LevelReader)level, relativePos)) {
            return face;
        }
        relativePos = pos.relative(face = face.getOpposite());
        if (RopeBlock.canConnectTo(level.getBlockState(relativePos), face, (LevelReader)level, relativePos)) {
            return face;
        }
        List<Direction> directions = Arrays.asList(context.getNearestLookingDirections());
        if (context.isSecondaryUseActive()) {
            Collections.reverse(directions);
        }
        for (int i = 0; i < 3; ++i) {
            Direction dir = directions.get(i);
            if (((Boolean)state.getValue((Property)RopeBlock.Y)).booleanValue()) {
                return Direction.DOWN;
            }
            if ((dir.getAxis() != Direction.Axis.X || !((Boolean)state.getValue((Property)RopeBlock.X)).booleanValue()) && (dir.getAxis() != Direction.Axis.Z || !((Boolean)state.getValue((Property)RopeBlock.Z)).booleanValue())) continue;
            block1: for (int j = 0; j < 2; ++j) {
                if (j == 1) {
                    dir = dir.getOpposite();
                }
                BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
                for (int k = 1; k < 7; ++k) {
                    mutableBlockPos.move(dir);
                    BlockState relativeState = level.getBlockState((BlockPos)mutableBlockPos);
                    if (relativeState.canBeReplaced() || relativeState.is(this.getBlock())) {
                        return dir;
                    }
                    if (!relativeState.is(this.getBlock())) continue block1;
                }
            }
        }
        return null;
    }
}

