/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.init.custom;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.util.TriConsumer;
import twilightforest.TFRegistries;
import twilightforest.init.TFDamageTypes;
import twilightforest.init.TFMobEffects;
import twilightforest.init.TFSounds;
import twilightforest.util.Enforcement;
import twilightforest.util.Restriction;

public class Enforcements {
    public static final DeferredRegister<Enforcement> ENFORCEMENTS = DeferredRegister.create(TFRegistries.Keys.ENFORCEMENT, (String)"twilightforest");
    public static final DeferredHolder<Enforcement, Enforcement> DARKNESS = ENFORCEMENTS.register("darkness", () -> new Enforcement((TriConsumer<Player, ServerLevel, Restriction>)((TriConsumer)(player, level, restriction) -> {
        if (player.tickCount % 60 == 0 && level.tickRateManager().runsNormally()) {
            player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 200, (int)restriction.multiplier(), false, true));
        }
    })));
    public static final DeferredHolder<Enforcement, Enforcement> HUNGER = ENFORCEMENTS.register("hunger", () -> new Enforcement((TriConsumer<Player, ServerLevel, Restriction>)((TriConsumer)(player, level, restriction) -> {
        if (player.tickCount % 60 == 0 && level.tickRateManager().runsNormally()) {
            MobEffectInstance currentHunger = player.getEffect(MobEffects.HUNGER);
            int hungerLevel = currentHunger != null ? currentHunger.getAmplifier() + (int)restriction.multiplier() : (int)restriction.multiplier();
            player.addEffect(new MobEffectInstance(MobEffects.HUNGER, 100, hungerLevel, false, true));
        }
    })));
    public static final DeferredHolder<Enforcement, Enforcement> FIRE = ENFORCEMENTS.register("fire", () -> new Enforcement((TriConsumer<Player, ServerLevel, Restriction>)((TriConsumer)(player, level, restriction) -> {
        if (player.tickCount % 60 == 0 && level.tickRateManager().runsNormally()) {
            player.igniteForSeconds((float)((int)restriction.multiplier()));
        }
    })));
    public static final DeferredHolder<Enforcement, Enforcement> FROST = ENFORCEMENTS.register("frost", () -> new Enforcement((TriConsumer<Player, ServerLevel, Restriction>)((TriConsumer)(player, level, restriction) -> {
        if (player.tickCount % 60 == 0 && level.tickRateManager().runsNormally()) {
            player.addEffect(new MobEffectInstance(TFMobEffects.FROSTY, 100, (int)restriction.multiplier(), false, true));
        }
    })));
    public static final DeferredHolder<Enforcement, Enforcement> ACID_RAIN = ENFORCEMENTS.register("acid_rain", () -> new Enforcement((TriConsumer<Player, ServerLevel, Restriction>)((TriConsumer)(player, level, restriction) -> {
        if (player.tickCount % 5 == 0 && level.tickRateManager().runsNormally() && player.hurt(TFDamageTypes.getDamageSource((Level)level, TFDamageTypes.ACID_RAIN, new EntityType[0]), restriction.multiplier())) {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)TFSounds.ACID_RAIN_BURNS.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    })));
}

