/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.events;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import twilightforest.advancements.SimpleAdvancementTrigger;
import twilightforest.block.TFPortalBlock;
import twilightforest.config.TFConfig;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.init.TFAdvancements;
import twilightforest.init.TFBlocks;
import twilightforest.init.TFDimension;
import twilightforest.network.MissingAdvancementToastPacket;
import twilightforest.network.StructureProtectionPacket;
import twilightforest.util.Enforcement;
import twilightforest.util.PlayerHelper;
import twilightforest.util.landmarks.LandmarkUtil;
import twilightforest.world.components.structures.util.AdvancementLockedStructure;
import twilightforest.world.components.structures.util.ProgressionPiece;

@EventBusSubscriber(modid="twilightforest")
public class TFTickHandler {
    @SubscribeEvent
    public static void playerTick(PlayerTickEvent.Post event) {
        Player eventPlayer = event.getEntity();
        if (!(eventPlayer instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)eventPlayer;
        Level level = player.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)level;
        if (!TFConfig.disablePortalCreation && player.tickCount % (!TFConfig.checkPortalPlacement ? 100 : 20) == 0 && world.getServer().getProfilePermissions(player.getGameProfile()) >= TFConfig.portalCreationPermission) {
            TFTickHandler.checkForPortalCreation(player, (Level)world, TFConfig.portalCreationPermission >= 3 ? 4.0f : 32.0f);
        }
        if (player.tickCount % 20 == 0 && LandmarkUtil.isProgressionEnforced((Level)world) && !player.isCreative() && !player.isSpectator()) {
            Enforcement.enforceBiomeProgression((Player)player, world);
        }
        if (player.tickCount % 100 == 0 && LandmarkUtil.isProgressionEnforced((Level)world)) {
            if (player.isCreative() || player.isSpectator()) {
                TFTickHandler.sendAllClearPacket((Player)player);
            } else {
                TFTickHandler.checkForLockedStructuresSendPacket((Player)player, world);
            }
        }
    }

    private static void sendStructureProtectionPacket(Player player, List<Pair<BoundingBox, Boolean>> sbbData) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new StructureProtectionPacket(Optional.of(sbbData)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static void sendAllClearPacket(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)sp, (CustomPacketPayload)new StructureProtectionPacket(Optional.empty()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static boolean checkForLockedStructuresSendPacket(Player player, ServerLevel world) {
        ChunkPos chunkPlayer = player.chunkPosition();
        return LandmarkUtil.locateNearestLandmarkStart((LevelAccessor)world, chunkPlayer.x, chunkPlayer.z).map(structureStart -> {
            AdvancementLockedStructure advancementLockedStructure;
            Structure patt0$temp = structureStart.getStructure();
            if (patt0$temp instanceof AdvancementLockedStructure && !(advancementLockedStructure = (AdvancementLockedStructure)patt0$temp).doesPlayerHaveRequiredAdvancements(player)) {
                List<Pair<BoundingBox, Boolean>> boundingBoxesData = structureStart.getPieces().stream().map(piece -> Pair.of((Object)(TFTickHandler.isProtected(piece) ? piece.getBoundingBox().inflatedBy(4) : piece.getBoundingBox()), (Object)TFTickHandler.isProtected(piece))).toList();
                TFTickHandler.sendStructureProtectionPacket(player, boundingBoxesData);
                return true;
            }
            TFTickHandler.sendAllClearPacket(player);
            return false;
        }).orElse(false);
    }

    private static boolean isProtected(StructurePiece piece) {
        ProgressionPiece progressionPiece;
        return !(piece instanceof ProgressionPiece) || (progressionPiece = (ProgressionPiece)piece).isComponentProtected();
    }

    private static void checkForPortalCreation(ServerPlayer player, Level world, float rangeToCheck) {
        if (world.dimension().location().equals((Object)ResourceLocation.parse((String)TFConfig.originDimension)) || TFDimension.isTwilightPortalDestination(world) || TFConfig.allowPortalsInOtherDimensions) {
            AdvancementHolder requirement;
            List itemList = world.getEntitiesOfClass(ItemEntity.class, player.getBoundingBox().inflate((double)rangeToCheck));
            ItemEntity qualified = null;
            for (ItemEntity entityItem : itemList) {
                if (!entityItem.getItem().is(ItemTagGenerator.PORTAL_ACTIVATOR) || !((TFPortalBlock)((Object)TFBlocks.TWILIGHT_PORTAL.get())).canFormPortal(world.getBlockState(entityItem.blockPosition())) || !Objects.equals(entityItem.getOwner(), player)) continue;
                qualified = entityItem;
                break;
            }
            if (qualified == null) {
                return;
            }
            if (!(player.isCreative() || player.isSpectator() || TFConfig.getPortalLockingAdvancement((Player)player) == null || (requirement = PlayerHelper.getAdvancement((Player)player, Objects.requireNonNull(TFConfig.getPortalLockingAdvancement((Player)player)))) == null || PlayerHelper.doesPlayerHaveRequiredAdvancement((Player)player, requirement))) {
                player.displayClientMessage(TFPortalBlock.PORTAL_UNWORTHY, true);
                if (!TFPortalBlock.isPlayerNotifiedOfRequirement(player)) {
                    DisplayInfo info = requirement.value().display().orElse(null);
                    PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)(info == null ? new MissingAdvancementToastPacket((Component)Component.translatable((String)"twilightforest.ui.advancement.no_title"), new ItemStack((ItemLike)TFBlocks.TWILIGHT_PORTAL_MINIATURE_STRUCTURE.get())) : new MissingAdvancementToastPacket(info.getTitle(), info.getIcon())), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    TFPortalBlock.playerNotifiedOfRequirement(player);
                }
                return;
            }
            Random rand = new Random();
            for (int i = 0; i < 2; ++i) {
                double vx = rand.nextGaussian() * 0.02;
                double vy = rand.nextGaussian() * 0.02;
                double vz = rand.nextGaussian() * 0.02;
                world.addParticle((ParticleOptions)ParticleTypes.EFFECT, qualified.getX(), qualified.getY() + 0.2, qualified.getZ(), vx, vy, vz);
            }
            if (((TFPortalBlock)((Object)TFBlocks.TWILIGHT_PORTAL.get())).tryToCreatePortal(world, qualified.blockPosition(), qualified, (Player)player)) {
                ((SimpleAdvancementTrigger)((Object)TFAdvancements.MADE_TF_PORTAL.get())).trigger(player);
            }
        }
    }
}

