/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import twilightforest.entity.projectile.TomeBolt;
import twilightforest.init.TFEntities;
import twilightforest.init.TFSounds;
import twilightforest.loot.TFLootTables;

public class DeathTome
extends Monster
implements RangedAttackMob {
    private static final EntityDataAccessor<Boolean> DATA_LECTERN = SynchedEntityData.defineId(DeathTome.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;

    public DeathTome(EntityType<? extends DeathTome> type, Level world) {
        super(type, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 10, false);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new RangedAttackGoal((RangedAttackMob)this, 1.0, 100, 5.0f));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal<Player>(this, (Mob)this, Player.class, true){

            protected void findTarget() {
                DeathTome tome;
                Mob mob = this.mob;
                if (mob instanceof DeathTome && (tome = (DeathTome)mob).isOnLectern()) {
                    this.target = tome.level().getNearestPlayer(tome.getX(), tome.getY(), tome.getZ(), 3.0, entity -> {
                        Player player;
                        return entity instanceof Player && !(player = (Player)entity).isShiftKeyDown() && tome.isInPlayersView((LivingEntity)player, 0.25, false, true, tome.getEyeY(), tome.getY() + 0.5 * (double)tome.getScale(), (tome.getEyeY() + tome.getY()) / 2.0) && EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(player);
                    });
                } else {
                    super.findTarget();
                }
            }
        });
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FLYING_SPEED, 0.6).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_LECTERN, (Object)false);
    }

    public void setOnLectern(boolean hidden) {
        this.getEntityData().set(DATA_LECTERN, (Object)hidden);
    }

    public boolean isOnLectern() {
        return (Boolean)this.getEntityData().get(DATA_LECTERN);
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation(this, (Mob)this, level){

            public boolean isStableDestination(BlockPos pos) {
                return !this.level.getBlockState(pos.below()).isAir();
            }
        };
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(false);
        flyingpathnavigation.setCanPassDoors(true);
        return flyingpathnavigation;
    }

    public boolean isPersistenceRequired() {
        return super.isPersistenceRequired() || this.isOnLectern();
    }

    public void aiStep() {
        if (this.isOnLectern()) {
            BlockState state = this.level().getBlockState(this.blockPosition());
            if (state.getBlock() instanceof LecternBlock) {
                Direction direction = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
                this.yRotO = direction.toYRot();
                this.setYRot(this.yRotO);
                this.yBodyRot = this.yRotO;
                this.yBodyRotO = this.yRotO;
                this.yHeadRot = this.yRotO;
                this.yHeadRotO = this.yRotO;
                if (!this.level().isClientSide()) {
                    this.targetSelector.tick();
                }
                if (this.getTarget() != null) {
                    this.setOnLectern(false);
                    this.setDeltaMovement(0.0, 0.25, 0.0);
                    this.performRangedAttack(this.getTarget(), 1.0f);
                }
                return;
            }
            this.setOnLectern(false);
        }
        super.aiStep();
        Vec3 vel = this.getDeltaMovement();
        if (!this.onGround() && vel.y() < 0.0) {
            this.setDeltaMovement(vel.multiply(1.0, 0.6, 1.0));
        }
        for (int i = 0; i < 1; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.ENCHANT, this.getX() + (this.getRandom().nextDouble() - 0.5) * (double)this.getBbWidth(), this.getY() + this.getRandom().nextDouble() * ((double)this.getBbHeight() - 0.75) + 0.5, this.getZ() + (this.getRandom().nextDouble() - 0.5) * (double)this.getBbWidth(), 0.0, 0.5, 0.0);
        }
    }

    private boolean isInPlayersView(LivingEntity target, double tolerance, boolean scaleByDistance, boolean visual, double ... yValues) {
        Vec3 vec3 = target.getViewVector(1.0f).normalize();
        for (double d0 : yValues) {
            Vec3 vec31 = new Vec3(this.getX() - target.getX(), d0 - target.getEyeY(), this.getZ() - target.getZ());
            double d1 = vec31.length();
            vec31 = vec31.normalize();
            double d2 = vec3.dot(vec31);
            double d = scaleByDistance ? d1 : 1.0;
            if (!(d2 > 1.0 - tolerance / d) || !this.hasLineOfSight((Entity)target, visual ? ClipContext.Block.VISUAL : ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, d0)) continue;
            return true;
        }
        return false;
    }

    public boolean hasLineOfSight(Entity entity, ClipContext.Block block, ClipContext.Fluid fluid, double eyeHeight) {
        if (entity.level() != this.level()) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.getX(), eyeHeight, this.getZ());
        Vec3 vec31 = new Vec3(entity.getX(), entity.getEyeY(), entity.getZ());
        return !(vec31.distanceTo(vec3) > 128.0) && this.level().clip(new ClipContext(vec3, vec31, block, fluid, (Entity)this)).getType() == HitResult.Type.MISS;
    }

    public void tick() {
        if (this.isOnLectern()) {
            this.ambientSoundTime = -1;
        }
        if (this.level().isClientSide) {
            float f1 = this.flipT;
            if (this.random.nextInt(this.isOnLectern() ? 120 : 30) == 0) {
                do {
                    this.flipT += (float)(this.random.nextInt(4) - this.random.nextInt(4));
                } while (f1 == this.flipT);
            }
            this.oFlip = this.flip;
            float f = (this.flipT - this.flip) * 0.4f;
            f = Mth.clamp((float)f, (float)-0.2f, (float)0.2f);
            this.flipA += (f - this.flipA) * 0.9f;
            this.flip += this.flipA;
        }
        super.tick();
    }

    public boolean hurt(DamageSource src, float damage) {
        if (src.is(DamageTypeTags.IS_FIRE)) {
            damage *= 2.0f;
        }
        if (super.hurt(src, damage)) {
            if (damage > 0.0f) {
                if (this.isOnLectern()) {
                    this.setDeltaMovement(0.0, 0.25, 0.0);
                    this.setOnLectern(false);
                }
                if (!this.level().isClientSide()) {
                    LootParams ctx = TFLootTables.createLootParams((LivingEntity)this, true, src).create(LootContextParamSets.ENTITY);
                    Objects.requireNonNull(this.level().getServer()).reloadableRegistries().getLootTable(TFLootTables.DEATH_TOME_HURT).getRandomItems(ctx, s -> this.spawnAtLocation((ItemStack)s, 1.0f));
                }
            }
            return true;
        }
        return false;
    }

    protected boolean canRide(Entity entity) {
        return false;
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return (SoundEvent)TFSounds.DEATH_TOME_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return (SoundEvent)TFSounds.DEATH_TOME_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)TFSounds.DEATH_TOME_DEATH.get();
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        TomeBolt projectile = new TomeBolt((EntityType<? extends TomeBolt>)((EntityType)TFEntities.TOME_BOLT.get()), this.level(), (LivingEntity)this);
        double tx = target.getX() - this.getX();
        double ty = target.getY() + (double)target.getEyeHeight() - 1.1 - projectile.getY();
        double tz = target.getZ() - this.getZ();
        float heightOffset = Mth.sqrt((float)((float)(tx * tx + tz * tz))) * 0.2f;
        projectile.shoot(tx, ty + (double)heightOffset, tz, 0.6f, 6.0f);
        this.gameEvent((Holder)GameEvent.PROJECTILE_SHOOT);
        this.level().addFreshEntity((Entity)projectile);
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.entityData.set(DATA_LECTERN, (Object)tag.getBoolean("on_lectern"));
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("on_lectern", ((Boolean)this.entityData.get(DATA_LECTERN)).booleanValue());
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }
}

