/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import twilightforest.beanification.Component;

@Component
public class CountTemplateCommand {
    public LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"count_template").requires(cs -> cs.hasPermission(2))).then(Commands.argument((String)"filter_structure", (ArgumentType)ResourceKeyArgument.key((ResourceKey)Registries.STRUCTURE)).executes(this::countTemplates));
    }

    private int countTemplates(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Holder.Reference structure = ResourceKeyArgument.getStructure(context, (String)"filter_structure");
        if (!structure.isBound()) {
            return 0;
        }
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerLevel level = source.getLevel();
        BlockPos commandPos = BlockPos.containing((Position)source.getPosition());
        StructureStart structureAt = level.structureManager().getStructureAt(commandPos, (Structure)structure.value());
        Object2IntOpenHashMap templateCounts = new Object2IntOpenHashMap();
        List structurePieces = structureAt.getPieces();
        for (StructurePiece piece : structurePieces) {
            if (!(piece instanceof TemplateStructurePiece)) continue;
            TemplateStructurePiece templatePiece = (TemplateStructurePiece)piece;
            ResourceLocation resourceLocation = templatePiece.makeTemplateLocation();
            templateCounts.put((Object)resourceLocation, templateCounts.getOrDefault((Object)resourceLocation, 0) + 1);
        }
        for (Object2IntMap.Entry countedTemplate : templateCounts.object2IntEntrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue)).toList()) {
            MutableComponent text = net.minecraft.network.chat.Component.literal((String)(String.valueOf(countedTemplate.getKey()) + "    " + countedTemplate.getIntValue()));
            ((CommandSourceStack)context.getSource()).sendSystemMessage((net.minecraft.network.chat.Component)text);
        }
        return templateCounts.size();
    }
}

