/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block.entity;

import com.google.common.base.MoreObjects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import twilightforest.init.TFBlockEntities;

public class ReactorDebrisBlockEntity
extends BlockEntity {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{ResourceLocation.withDefaultNamespace((String)"block/netherrack"), ResourceLocation.withDefaultNamespace((String)"block/bedrock"), ResourceLocation.withDefaultNamespace((String)"block/nether_portal"), ResourceLocation.withDefaultNamespace((String)"block/obsidian")};
    public static final ResourceLocation DEFAULT_TEXTURE = TEXTURES[0];
    private static final float Z_FIGHTING_MIN = 0.008f;
    private static final float Z_FIGHTING_MAX = 0.992f;
    private static final Random RANDOM = new Random();
    private boolean rerolls = false;
    private boolean willDisappear = true;
    private byte timeAlive = 0;
    public VoxelShape shape = Shapes.empty();
    public ResourceLocation[] textures = new ResourceLocation[6];
    public Vector3f minPos = new Vector3f(0.008f);
    public Vector3f maxPos = new Vector3f(0.992f);

    public ReactorDebrisBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)TFBlockEntities.REACTOR_DEBRIS.get(), pos, blockState);
    }

    public void randomizeTextures() {
        for (int i = 0; i < this.textures.length; ++i) {
            this.textures[i] = TEXTURES[RANDOM.nextInt(TEXTURES.length)];
        }
    }

    public void randomizeDimensions() {
        this.shape = ReactorDebrisBlockEntity.calculateVoxelShape();
        AABB aabb = this.shape.bounds();
        this.minPos = new Vector3f((float)aabb.minX, (float)aabb.minY, (float)aabb.minZ);
        this.maxPos = new Vector3f((float)aabb.maxX, (float)aabb.maxY, (float)aabb.maxZ);
    }

    public static VoxelShape calculateVoxelShape() {
        float lengthZ;
        float lengthY;
        float minX = (float)RANDOM.nextInt(16) / 16.0f;
        float minY = (float)RANDOM.nextInt(16) / 16.0f;
        float minZ = (float)RANDOM.nextInt(16) / 16.0f;
        float lengthX = (float)RANDOM.nextInt(1, (int)(17.0f - minX * 16.0f)) / 16.0f;
        if ((double)(lengthX * (lengthY = (float)RANDOM.nextInt(1, (int)(17.0f - minY * 16.0f)) / 16.0f) * (lengthZ = (float)RANDOM.nextInt(1, (int)(17.0f - minZ * 16.0f)) / 16.0f)) < 0.125) {
            return ReactorDebrisBlockEntity.calculateVoxelShape();
        }
        return Shapes.box((double)ReactorDebrisBlockEntity.clampToSmallerCube(minX), (double)ReactorDebrisBlockEntity.clampToSmallerCube(minY), (double)ReactorDebrisBlockEntity.clampToSmallerCube(minZ), (double)ReactorDebrisBlockEntity.clampToSmallerCube(minX + lengthX), (double)ReactorDebrisBlockEntity.clampToSmallerCube(minY + lengthY), (double)ReactorDebrisBlockEntity.clampToSmallerCube(minZ + lengthZ));
    }

    private static double clampToSmallerCube(double value) {
        return Math.min(Math.max(value, (double)0.008f), (double)0.992f);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, ReactorDebrisBlockEntity reactorDebrisBlockEntity) {
        if (reactorDebrisBlockEntity.willDisappear && reactorDebrisBlockEntity.timeAlive == 5 || reactorDebrisBlockEntity.rerolls && RANDOM.nextInt(5) == 0) {
            reactorDebrisBlockEntity.randomizeDimensions();
            reactorDebrisBlockEntity.randomizeTextures();
        }
        if (!reactorDebrisBlockEntity.willDisappear) {
            return;
        }
        reactorDebrisBlockEntity.timeAlive = (byte)(reactorDebrisBlockEntity.timeAlive + 1);
        if (reactorDebrisBlockEntity.timeAlive >= 60) {
            level.destroyBlock(blockPos, false);
        }
    }

    @NotNull
    private static ResourceLocation nonEmptyNotNull(String texturesString) {
        if (texturesString.isBlank()) {
            return DEFAULT_TEXTURE;
        }
        return (ResourceLocation)MoreObjects.firstNonNull((Object)ResourceLocation.tryParse((String)texturesString), (Object)DEFAULT_TEXTURE);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        ListTag sizeTag;
        super.loadAdditional(tag, registries);
        CompoundTag textures = tag.getCompound("textures");
        this.textures[0] = ReactorDebrisBlockEntity.nonEmptyNotNull(textures.getString("west"));
        this.textures[1] = ReactorDebrisBlockEntity.nonEmptyNotNull(textures.getString("east"));
        this.textures[2] = ReactorDebrisBlockEntity.nonEmptyNotNull(textures.getString("bottom"));
        this.textures[3] = ReactorDebrisBlockEntity.nonEmptyNotNull(textures.getString("top"));
        this.textures[4] = ReactorDebrisBlockEntity.nonEmptyNotNull(textures.getString("north"));
        this.textures[5] = ReactorDebrisBlockEntity.nonEmptyNotNull(textures.getString("south"));
        ListTag posTag = tag.getList("pos", 5);
        if (posTag.size() == 3) {
            this.minPos = new Vector3f(posTag.getFloat(0), posTag.getFloat(1), posTag.getFloat(2));
        }
        if (!new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).contains((double)this.minPos.x, (double)this.minPos.y, (double)this.minPos.z)) {
            this.minPos = new Vector3f();
        }
        if ((sizeTag = tag.getList("sizes", 5)).size() == 3) {
            this.maxPos = new Vector3f(sizeTag.getFloat(0), sizeTag.getFloat(1), sizeTag.getFloat(2)).add((Vector3fc)this.minPos);
        }
        if (!new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0).contains((double)this.minPos.x, (double)this.minPos.y, (double)this.minPos.z)) {
            this.maxPos = new Vector3f(1.0f);
        }
        this.shape = Shapes.box((double)this.minPos.x, (double)this.minPos.y, (double)this.minPos.z, (double)this.maxPos.x, (double)this.maxPos.y, (double)this.maxPos.z);
        this.rerolls = tag.getBoolean("rerolls");
        this.willDisappear = tag.getBoolean("will_disappear");
        this.timeAlive = tag.getByte("timeAlive");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        CompoundTag textures = new CompoundTag();
        textures.putString("west", this.textures[0].toString());
        textures.putString("east", this.textures[1].toString());
        textures.putString("bottom", this.textures[2].toString());
        textures.putString("top", this.textures[3].toString());
        textures.putString("north", this.textures[4].toString());
        textures.putString("south", this.textures[5].toString());
        tag.put("textures", (Tag)textures);
        tag.put("pos", (Tag)this.newFloatList(this.minPos.x, this.minPos.y, this.minPos.z));
        tag.put("sizes", (Tag)this.newFloatList(this.maxPos.x - this.minPos.x, this.maxPos.y - this.minPos.y, this.maxPos.z - this.minPos.z));
        tag.putBoolean("rerolls", this.rerolls);
        tag.putBoolean("will_disappear", this.willDisappear);
        tag.putByte("timeAlive", this.timeAlive);
    }

    protected ListTag newFloatList(float ... values) {
        ListTag listTag = new ListTag();
        for (float value : values) {
            listTag.add((Object)FloatTag.valueOf((float)value));
        }
        return listTag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveCustomOnly(registries);
    }
}

