/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.Iterables;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.Nullable;
import twilightforest.block.LightableBlock;
import twilightforest.block.entity.CandelabraBlockEntity;
import twilightforest.components.item.CandelabraData;
import twilightforest.data.tags.ItemTagGenerator;
import twilightforest.init.TFItems;
import twilightforest.init.TFParticleType;
import twilightforest.init.TFSounds;

public class CandelabraBlock
extends BaseEntityBlock
implements LightableBlock,
SimpleWaterloggedBlock {
    public static final BooleanProperty ON_WALL = BooleanProperty.create((String)"on_wall");
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final List<BooleanProperty> CANDLES = List.of(BooleanProperty.create((String)"has_candle_1"), BooleanProperty.create((String)"has_candle_2"), BooleanProperty.create((String)"has_candle_3"));
    public static final VoxelShape CANDLES_NORTH = Shapes.or((VoxelShape)Block.box((double)1.0, (double)7.0, (double)2.0, (double)15.0, (double)15.0, (double)6.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)1.0, (double)3.5, (double)15.0, (double)7.0, (double)4.5), Block.box((double)7.5, (double)1.0, (double)1.0, (double)8.5, (double)7.0, (double)7.0), Block.box((double)6.0, (double)2.0, (double)0.0, (double)10.0, (double)6.0, (double)1.0)});
    public static final VoxelShape CANDLES_SOUTH = Shapes.or((VoxelShape)Block.box((double)1.0, (double)7.0, (double)10.0, (double)15.0, (double)15.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)1.0, (double)11.5, (double)15.0, (double)7.0, (double)12.5), Block.box((double)7.5, (double)1.0, (double)9.0, (double)8.5, (double)7.0, (double)15.0), Block.box((double)6.0, (double)2.0, (double)15.0, (double)10.0, (double)6.0, (double)16.0)});
    public static final VoxelShape CANDLES_WEST = Shapes.or((VoxelShape)Block.box((double)2.0, (double)7.0, (double)1.0, (double)6.0, (double)15.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)3.5, (double)1.0, (double)1.0, (double)4.5, (double)7.0, (double)15.0), Block.box((double)1.0, (double)1.0, (double)7.5, (double)7.0, (double)7.0, (double)8.5), Block.box((double)0.0, (double)2.0, (double)6.0, (double)1.0, (double)6.0, (double)10.0)});
    public static final VoxelShape CANDLES_EAST = Shapes.or((VoxelShape)Block.box((double)10.0, (double)7.0, (double)1.0, (double)14.0, (double)15.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)11.5, (double)1.0, (double)1.0, (double)12.5, (double)7.0, (double)15.0), Block.box((double)9.0, (double)1.0, (double)7.5, (double)15.0, (double)7.0, (double)8.5), Block.box((double)15.0, (double)2.0, (double)6.0, (double)16.0, (double)6.0, (double)10.0)});
    public static final VoxelShape CANDLES_X = Shapes.or((VoxelShape)Block.box((double)6.0, (double)7.0, (double)1.0, (double)10.0, (double)15.0, (double)15.0), (VoxelShape[])new VoxelShape[]{Block.box((double)7.5, (double)1.0, (double)1.0, (double)8.5, (double)7.0, (double)15.0), Block.box((double)5.0, (double)1.0, (double)7.5, (double)11.0, (double)7.0, (double)8.5), Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0)});
    public static final VoxelShape CANDLES_Z = Shapes.or((VoxelShape)Block.box((double)1.0, (double)7.0, (double)6.0, (double)15.0, (double)15.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)1.0, (double)7.5, (double)15.0, (double)7.0, (double)8.5), Block.box((double)7.5, (double)1.0, (double)5.0, (double)8.5, (double)7.0, (double)11.0), Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0)});
    public static final List<Vec3> NORTH_OFFSETS = List.of(new Vec3(0.1875, 0.9, 0.25), new Vec3(0.5, 0.9, 0.25), new Vec3(0.8125, 0.9, 0.25));
    public static final List<Vec3> SOUTH_OFFSETS = List.of(new Vec3(0.1875, 0.9, 0.75), new Vec3(0.5, 0.9, 0.75), new Vec3(0.8125, 0.9, 0.75));
    public static final List<Vec3> WEST_OFFSETS = List.of(new Vec3(0.25, 0.9, 0.1875), new Vec3(0.25, 0.9, 0.5), new Vec3(0.25, 0.9, 0.8125));
    public static final List<Vec3> EAST_OFFSETS = List.of(new Vec3(0.75, 0.9, 0.1875), new Vec3(0.75, 0.9, 0.5), new Vec3(0.75, 0.9, 0.8125));
    public static final List<Vec3> X_OFFSETS = List.of(new Vec3(0.5, 0.9, 0.1875), new Vec3(0.5, 0.9, 0.5), new Vec3(0.5, 0.9, 0.8125));
    public static final List<Vec3> Z_OFFSETS = List.of(new Vec3(0.1875, 0.9, 0.5), new Vec3(0.5, 0.9, 0.5), new Vec3(0.8125, 0.9, 0.5));
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final MapCodec<CandelabraBlock> CODEC = CandelabraBlock.simpleCodec(CandelabraBlock::new);

    public CandelabraBlock(BlockBehaviour.Properties properties) {
        super(properties);
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)LIGHTING, (Comparable)((Object)LightableBlock.Lighting.NONE))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)ON_WALL, (Comparable)Boolean.valueOf(false))).setValue((Property)LIGHTING, (Comparable)((Object)LightableBlock.Lighting.NONE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        for (BooleanProperty booleanproperty : CANDLES) {
            state = (BlockState)state.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(false));
        }
        this.registerDefaultState(state);
    }

    public static int getCandleCount(BlockState state) {
        int candleCount = 0;
        for (BooleanProperty property : CANDLES) {
            if (!((Boolean)state.getValue((Property)property)).booleanValue()) continue;
            ++candleCount;
        }
        return candleCount;
    }

    public static boolean canSurvive(LevelReader reader, BlockPos pos, boolean onWall, Direction facing) {
        return CandelabraBlock.canSupportCenter((LevelReader)reader, (BlockPos)(onWall ? pos.relative(facing) : pos.below()), (Direction)Direction.UP);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public int getLightEmission(BlockState state, BlockGetter getter, BlockPos pos) {
        int candleCount = CandelabraBlock.getCandleCount(state);
        return switch ((LightableBlock.Lighting)((Object)state.getValue((Property)LIGHTING))) {
            case LightableBlock.Lighting.DIM, LightableBlock.Lighting.OMINOUS -> 2 * candleCount;
            case LightableBlock.Lighting.NORMAL -> 5 * candleCount;
            default -> 0;
        };
    }

    @Override
    public Iterable<Vec3> getParticleOffsets(BlockState state, LevelAccessor accessor, BlockPos pos) {
        if (((Boolean)state.getValue((Property)ON_WALL)).booleanValue()) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                case Direction.SOUTH -> SOUTH_OFFSETS;
                case Direction.WEST -> WEST_OFFSETS;
                case Direction.EAST -> EAST_OFFSETS;
                default -> NORTH_OFFSETS;
            };
        }
        return ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? X_OFFSETS : Z_OFFSETS;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.getValue((Property)ON_WALL)).booleanValue()) {
            return switch ((Direction)state.getValue((Property)FACING)) {
                case Direction.SOUTH -> CANDLES_SOUTH;
                case Direction.WEST -> CANDLES_WEST;
                case Direction.EAST -> CANDLES_EAST;
                default -> CANDLES_NORTH;
            };
        }
        return ((Direction)state.getValue((Property)FACING)).getAxis() == Direction.Axis.X ? CANDLES_X : CANDLES_Z;
    }

    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        if (ItemAbilities.FIRESTARTER_LIGHT == itemAbility && this.canBeLit(state)) {
            return (BlockState)state.setValue((Property)LIGHTING, (Comparable)((Object)LightableBlock.Lighting.NORMAL));
        }
        return super.getToolModifiedState(state, context, itemAbility, simulate);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (stack.is(ItemTags.CANDLES) || player.isShiftKeyDown()) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CandelabraBlockEntity) {
                Item item;
                CandelabraBlockEntity candelabra = (CandelabraBlockEntity)blockEntity;
                int i = this.getSlot((Direction)state.getValue((Property)FACING), result.getLocation().subtract((double)result.getBlockPos().getX(), (double)result.getBlockPos().getY(), (double)result.getBlockPos().getZ()));
                if (((Boolean)state.getValue((Property)CANDLES.get(i))).booleanValue() && player.isShiftKeyDown()) {
                    ItemStack itemstack = new ItemStack((ItemLike)candelabra.removeCandle(i));
                    level.playSound(null, pos, SoundEvents.CANDLE_PLACE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
                    if (player.hasInfiniteMaterials()) {
                        if (!player.getInventory().contains(itemstack)) {
                            player.getInventory().add(itemstack);
                        }
                    } else if (!player.getInventory().add(itemstack)) {
                        player.drop(itemstack, false);
                    }
                    level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
                }
                if (!((Boolean)state.getValue((Property)CANDLES.get(i))).booleanValue() && stack.is(ItemTags.CANDLES) && (item = stack.getItem()) instanceof BlockItem) {
                    BlockItem block = (BlockItem)item;
                    if (!level.isClientSide()) {
                        player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                        candelabra.setCandle(i, block.getBlock());
                        level.playSound(null, pos, SoundEvents.CANDLE_PLACE, SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
                        stack.consume(1, (LivingEntity)player);
                    }
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
                }
                return ItemInteractionResult.CONSUME;
            }
        } else {
            if (stack.is(Tags.Items.DUSTS_REDSTONE) && state.getValue((Property)LIGHTING) == LightableBlock.Lighting.NORMAL) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIGHTING, (Comparable)((Object)LightableBlock.Lighting.DIM)));
                stack.consume(1, (LivingEntity)player);
                level.playSound(null, pos, (SoundEvent)TFSounds.CANDELABRA_LIGHT.get(), SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
                if (level.isClientSide()) {
                    this.eruptFlameParticles((ParticleOptions)TFParticleType.DIM_FLAME.get(), level, pos, state);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
            if ((stack.is(ItemTagGenerator.SCEPTERS) || stack.is(TFItems.EXANIMATE_ESSENCE)) && state.getValue((Property)LIGHTING) == LightableBlock.Lighting.NORMAL) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LIGHTING, (Comparable)((Object)LightableBlock.Lighting.OMINOUS)));
                level.playSound(null, pos, (SoundEvent)TFSounds.CANDELABRA_OMINOUS.get(), SoundSource.BLOCKS, 1.0f, level.getRandom().nextFloat() * 0.1f + 0.9f);
                if (level.isClientSide()) {
                    this.eruptFlameParticles((ParticleOptions)TFParticleType.OMINOUS_FLAME.get(), level, pos, state);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
            }
        }
        return this.tryLightCandles(stack, state, level, pos, player);
    }

    private void eruptFlameParticles(ParticleOptions particle, Level level, BlockPos pos, BlockState state) {
        for (int i = 0; i < 3; ++i) {
            if (!((Boolean)state.getValue((Property)CANDLES.get(i))).booleanValue()) continue;
            Vec3 vec = (Vec3)Iterables.get(this.getParticleOffsets(state, (LevelAccessor)level, pos), (int)i);
            for (int j = 0; j < 5; ++j) {
                level.addParticle(particle, (double)pos.getX() + vec.x, (double)pos.getY() + vec.y, (double)pos.getZ() + vec.z, (level.getRandom().nextDouble() - 0.5) * 0.05, (double)0.015f, (level.getRandom().nextDouble() - 0.5) * 0.05);
            }
        }
    }

    protected void updateNeighborsBasedOnRotation(Level level, BlockPos pos, BlockState state) {
        if (((Boolean)state.getValue((Property)ON_WALL)).booleanValue()) {
            Direction direction = (Direction)state.getValue((Property)FACING);
            BlockPos blockpos = pos.relative(direction);
            level.neighborChanged(blockpos, (Block)this, pos);
            level.updateNeighborsAtExceptFromFacing(blockpos, (Block)this, direction.getOpposite());
        } else {
            level.neighborChanged(pos.below(), (Block)this, pos);
            level.updateNeighborsAtExceptFromFacing(pos.below(), (Block)this, Direction.UP);
        }
    }

    protected int getSlot(Direction blockDir, Vec3 hitVec) {
        Vec3i up = new Vec3i(0, 1, 0);
        Vec3i dir = up.cross(blockDir.getNormal());
        boolean reverse = blockDir == Direction.NORTH || blockDir == Direction.EAST;
        double cx = (double)dir.getX() * hitVec.x() + (double)dir.getZ() * hitVec.z();
        if (cx <= 0.0) {
            cx += 1.0;
        }
        if (cx <= 0.375) {
            return reverse ? 2 : 0;
        }
        return cx <= 0.6875 ? 1 : (reverse ? 0 : 2);
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult result, Projectile projectile) {
        this.lightCandlesWithProjectile(level, state, result, projectile);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction clickDirection = context.getClickedFace();
        boolean onBottomBlock = clickDirection == Direction.UP;
        Direction[] placements = context.getNearestLookingDirections();
        BlockPos placePos = context.getClickedPos();
        Level level = context.getLevel();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidstate.is((Fluid)Fluids.WATER);
        if (onBottomBlock) {
            if (CandelabraBlock.canSurvive((LevelReader)level, placePos, false, context.getHorizontalDirection())) {
                return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)ON_WALL, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
            }
            for (Direction nextSide : placements) {
                if (!nextSide.getAxis().isHorizontal() || !CandelabraBlock.canSurvive((LevelReader)level, placePos, true, nextSide)) continue;
                return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)nextSide)).setValue((Property)ON_WALL, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
            }
        } else {
            for (Direction nextSide : placements) {
                if (!nextSide.getAxis().isHorizontal() || !CandelabraBlock.canSurvive((LevelReader)level, placePos, true, nextSide)) continue;
                return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)nextSide)).setValue((Property)ON_WALL, (Comparable)Boolean.valueOf(true))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
            }
            if (CandelabraBlock.canSurvive((LevelReader)level, placePos, false, context.getHorizontalDirection())) {
                return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)ON_WALL, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
            }
        }
        return null;
    }

    @Override
    public boolean canBeLit(BlockState state) {
        return state.getValue((Property)LIGHTING) == LightableBlock.Lighting.NONE && (Boolean)state.getValue((Property)WATERLOGGED) == false && CandelabraBlock.getCandleCount(state) > 0;
    }

    public boolean placeLiquid(LevelAccessor accessor, BlockPos pos, BlockState state, FluidState fluid) {
        if (!((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && fluid.is((Fluid)Fluids.WATER)) {
            boolean flag;
            boolean bl = flag = state.getValue((Property)LIGHTING) != LightableBlock.Lighting.NONE;
            if (flag) {
                this.extinguish(null, state, accessor, pos);
            }
            accessor.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)LIGHTING, (Comparable)((Object)LightableBlock.Lighting.NONE)), 3);
            accessor.scheduleTick(pos, fluid.getType(), fluid.getType().getTickDelay((LevelReader)accessor));
            return true;
        }
        return false;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, ON_WALL, LIGHTING, WATERLOGGED});
        CANDLES.forEach(xva$0 -> builder.add(new Property[]{xva$0}));
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        return CandelabraBlock.canSurvive(reader, pos, (Boolean)state.getValue((Property)ON_WALL), (Direction)state.getValue((Property)FACING));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (state.getValue((Property)LIGHTING) != LightableBlock.Lighting.NONE) {
            for (int i = 0; i < 3; ++i) {
                if (!((Boolean)state.getValue((Property)CANDLES.get(i))).booleanValue()) continue;
                Vec3 vec = (Vec3)Iterables.get(this.getParticleOffsets(state, (LevelAccessor)level, pos), (int)i);
                this.addParticlesAndSound(level, pos, vec.x, vec.y, vec.z, rand, (LightableBlock.Lighting)((Object)state.getValue((Property)LIGHTING)));
            }
        }
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor accessor, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            accessor.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)accessor));
        }
        return super.updateShape(state, facing, facingState, accessor, currentPos, facingPos);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CandelabraBlockEntity(pos, state);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity blockEntity;
        List drops = super.getDrops(state, builder);
        Optional<ItemStack> base = drops.stream().filter(item -> item.is(this.asItem())).findFirst();
        if (base.isPresent() && (blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY)) instanceof CandelabraBlockEntity) {
            CandelabraBlockEntity candelabra = (CandelabraBlockEntity)blockEntity;
            RegistryAccess access = blockEntity.getLevel().registryAccess();
            if (!((ItemStack)builder.getParameter(LootContextParams.TOOL)).isEmpty() && ((ItemStack)builder.getParameter(LootContextParams.TOOL)).getEnchantmentLevel((Holder)access.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.SILK_TOUCH)) > 0) {
                ItemStack newStack = new ItemStack((ItemLike)this);
                newStack.applyComponents(candelabra.collectComponents());
                drops.remove(base.get());
                drops.add(newStack);
            } else {
                candelabra.getCandles().ordered().forEach(block -> drops.add(new ItemStack((ItemLike)block)));
            }
        }
        return drops;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return state.getValue((Property)LIGHTING) == LightableBlock.Lighting.DIM && (Boolean)state.getValue((Property)ON_WALL) != false && ((Direction)state.getValue((Property)FACING)).getOpposite() == direction;
    }

    public int getSignal(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        if (state.getValue((Property)LIGHTING) == LightableBlock.Lighting.DIM) {
            if (((Boolean)state.getValue((Property)ON_WALL)).booleanValue()) {
                return state.getValue((Property)FACING) == direction.getOpposite() ? CandelabraBlock.getCandleCount(state) * 3 : 0;
            }
            return direction == Direction.UP ? CandelabraBlock.getCandleCount(state) * 3 : 0;
        }
        return 0;
    }

    public int getDirectSignal(BlockState state, BlockGetter getter, BlockPos pos, Direction direction) {
        return state.getSignal(getter, pos, direction);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        int candleCount = CandelabraBlock.getCandleCount(state);
        return switch ((LightableBlock.Lighting)((Object)state.getValue((Property)LIGHTING))) {
            case LightableBlock.Lighting.DIM -> 3 + candleCount;
            case LightableBlock.Lighting.OMINOUS -> 6 + candleCount;
            case LightableBlock.Lighting.NORMAL -> 9 + candleCount;
            default -> candleCount;
        };
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        this.updateNeighborsBasedOnRotation(level, pos, state);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CandelabraBlockEntity) {
            CandelabraBlockEntity candelabra = (CandelabraBlockEntity)blockEntity;
            if (!newState.is(state.getBlock())) {
                candelabra.updateState(0);
            }
        }
        super.onPlace(state, level, pos, newState, moving);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moving) {
        if (!state.is(newState.getBlock())) {
            this.updateNeighborsBasedOnRotation(level, pos, state);
        }
        super.onRemove(state, level, pos, newState, moving);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        CandelabraBlockEntity candelabra;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CandelabraBlockEntity && (candelabra = (CandelabraBlockEntity)blockEntity).getCandles() != CandelabraData.EMPTY) {
            ItemStack itemstack = new ItemStack((ItemLike)this);
            itemstack.applyComponents(candelabra.collectComponents());
            return itemstack;
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }
}

