/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.advancements.predicate;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.critereon.SingleComponentItemPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;

public record ItemColorPredicate(int color) implements SingleComponentItemPredicate<DyedItemColor>
{
    public static final Codec<ItemColorPredicate> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("color", (Object)-1).forGetter(ItemColorPredicate::color)).apply((Applicative)instance, ItemColorPredicate::new));

    public DataComponentType<DyedItemColor> componentType() {
        return DataComponents.DYED_COLOR;
    }

    public boolean matches(ItemStack stack, DyedItemColor value) {
        if (stack.has(DataComponents.DYED_COLOR) && this.color() == -1) {
            return true;
        }
        return value.rgb() == this.color();
    }

    public static ItemColorPredicate anyColor() {
        return new ItemColorPredicate(-1);
    }

    public static ItemColorPredicate withColor(int color) {
        return new ItemColorPredicate(color);
    }
}

