/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.style.inner;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.xylonity.tooltipoverhaul.client.TooltipContext;
import dev.xylonity.tooltipoverhaul.client.layer.LayerDepth;
import dev.xylonity.tooltipoverhaul.client.layer.bridge.ITooltipFrame;
import java.awt.Point;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;

public class GlintInnerOverlay
implements ITooltipFrame {
    private final int color1;
    private final int color2;
    private final int color3;
    private final int timesSegmentedColor1;
    private final int timesSegmentedColor2;
    private static final int MIN_SEGMENTS = 2;
    private static final int MAX_SEGMENTS = 24;

    public GlintInnerOverlay(int color1, int color2, int color3, int timesSegmentedColor1, int timesSegmentedColor2) {
        this.color1 = color1;
        this.color2 = color2;
        this.color3 = color3;
        this.timesSegmentedColor1 = timesSegmentedColor1;
        this.timesSegmentedColor2 = timesSegmentedColor2;
    }

    @Override
    public void render(LayerDepth depth, TooltipContext ctx, Vec2 pos, Point size) {
        this.glint(ctx.graphics(), (int)pos.x - 3, (int)pos.y - 3, size.x + 6, size.y + 6);
    }

    private void glint(GuiGraphics graphics, int x, int y, int width, int height) {
        if (width <= 1 || height <= 1) {
            return;
        }
        int lightRange = Math.max(1, width / Math.max(1, this.timesSegmentedColor1));
        int mediumRange = Math.max(1, width / Math.max(1, this.timesSegmentedColor2));
        int segmentWidth = GlintInnerOverlay.clamp(width / 12);
        int segmentHeight = GlintInnerOverlay.clamp(height / 12);
        int per = 2 * (width + height) - 4;
        int center = width / 4;
        this.drawHorizontalLine(graphics, x, y, width, 0, segmentWidth, per, center, lightRange, mediumRange, false);
        this.drawVerticalLine(graphics, x + width - 1, y + 1, height - 2, width, segmentHeight, per, center, lightRange, mediumRange, false);
        this.drawHorizontalLine(graphics, x, y + height - 1, width, width + height - 1, segmentWidth, per, center, lightRange, mediumRange, true);
        this.drawVerticalLine(graphics, x, y + 1, height - 2, 2 * width + height - 2, segmentHeight, per, center, lightRange, mediumRange, true);
    }

    private void drawHorizontalLine(GuiGraphics g, int x, int y, int length, int startIdx, int segments, int per, int center, int lightRange, int mediumRange, boolean reverse) {
        int run;
        if (length <= 0) {
            return;
        }
        int segmentLength = Math.max(1, length / segments);
        int px = x;
        for (int drawn = 0; drawn < length; drawn += run) {
            run = Math.min(segmentLength, length - drawn);
            int colorLeft = this.colorAt(startIdx + (reverse ? length - 1 - drawn : drawn), per, center, lightRange, mediumRange);
            int colorRight = this.colorAt(startIdx + (reverse ? length - drawn - run : drawn + run - 1), per, center, lightRange, mediumRange);
            GlintInnerOverlay.makeHorizontalGradient(g, px, y, px + run, y + 1, colorLeft, colorRight);
            px += run;
        }
    }

    private void drawVerticalLine(GuiGraphics graphics, int x, int y, int length, int startIdx, int segments, int per, int center, int lightRange, int mediumRange, boolean reverse) {
        int run;
        if (length <= 0) {
            return;
        }
        int segmentLength = Math.max(1, length / segments);
        int py = y;
        for (int drawn = 0; drawn < length; drawn += run) {
            run = Math.min(segmentLength, length - drawn);
            int colorTop = this.colorAt(startIdx + (reverse ? length - 1 - drawn : drawn), per, center, lightRange, mediumRange);
            int colorBottom = this.colorAt(startIdx + (reverse ? length - drawn - run : drawn + run - 1), per, center, lightRange, mediumRange);
            GlintInnerOverlay.makeVerticalGradient(graphics, x, py, x + 1, py + run, colorTop, colorBottom);
            py += run;
        }
    }

    private static void makeHorizontalGradient(GuiGraphics graphics, int x1, int y1, int x2, int y2, int colorLeft, int colorRight) {
        int alphaLeft = colorLeft >>> 24 & 0xFF;
        int redLeft = colorLeft >>> 16 & 0xFF;
        int greenLeft = colorLeft >>> 8 & 0xFF;
        int blueLeft = colorLeft & 0xFF;
        int alphaRight = colorRight >>> 24 & 0xFF;
        int redRight = colorRight >>> 16 & 0xFF;
        int greenRight = colorRight >>> 8 & 0xFF;
        int blueRight = colorRight & 0xFF;
        PoseStack pose = graphics.pose();
        Matrix4f matrix = pose.last().pose();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buf = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        buf.addVertex(matrix, (float)x1, (float)y2, 0.0f).setColor(redLeft, greenLeft, blueLeft, alphaLeft);
        buf.addVertex(matrix, (float)x2, (float)y2, 0.0f).setColor(redRight, greenRight, blueRight, alphaRight);
        buf.addVertex(matrix, (float)x2, (float)y1, 0.0f).setColor(redRight, greenRight, blueRight, alphaRight);
        buf.addVertex(matrix, (float)x1, (float)y1, 0.0f).setColor(redLeft, greenLeft, blueLeft, alphaLeft);
        try (MeshData data = buf.buildOrThrow();){
            BufferUploader.drawWithShader((MeshData)data);
        }
    }

    private static void makeVerticalGradient(GuiGraphics graphics, int x1, int y1, int x2, int y2, int colorTop, int colorBottom) {
        int alphaTop = colorTop >>> 24 & 0xFF;
        int redTop = colorTop >>> 16 & 0xFF;
        int greenTop = colorTop >>> 8 & 0xFF;
        int blueTop = colorTop & 0xFF;
        int alphaBottom = colorBottom >>> 24 & 0xFF;
        int redBottom = colorBottom >>> 16 & 0xFF;
        int greenBottom = colorBottom >>> 8 & 0xFF;
        int blueBottom = colorBottom & 0xFF;
        PoseStack pose = graphics.pose();
        Matrix4f matrix = pose.last().pose();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buf = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        buf.addVertex(matrix, (float)x1, (float)y2, 0.0f).setColor(redBottom, greenBottom, blueBottom, alphaBottom);
        buf.addVertex(matrix, (float)x2, (float)y2, 0.0f).setColor(redBottom, greenBottom, blueBottom, alphaBottom);
        buf.addVertex(matrix, (float)x2, (float)y1, 0.0f).setColor(redTop, greenTop, blueTop, alphaTop);
        buf.addVertex(matrix, (float)x1, (float)y1, 0.0f).setColor(redTop, greenTop, blueTop, alphaTop);
        try (MeshData data = buf.buildOrThrow();){
            BufferUploader.drawWithShader((MeshData)data);
        }
    }

    private int colorAt(int i, int per, int center, int lightRange, int mediumRange) {
        i = GlintInnerOverlay.mod(i, per);
        int clockwiseDist = GlintInnerOverlay.mod(i - center, per);
        int cClockwiseDist = GlintInnerOverlay.mod(center - i, per);
        if (clockwiseDist <= lightRange) {
            return GlintInnerOverlay.blend(this.color1, this.color2, (float)clockwiseDist / (float)lightRange);
        }
        if (clockwiseDist <= lightRange + mediumRange) {
            return GlintInnerOverlay.blend(this.color2, this.color3, (float)(clockwiseDist - lightRange) / (float)mediumRange);
        }
        if (cClockwiseDist <= lightRange) {
            return GlintInnerOverlay.blend(this.color1, this.color2, (float)cClockwiseDist / (float)lightRange);
        }
        if (cClockwiseDist <= lightRange + mediumRange) {
            return GlintInnerOverlay.blend(this.color2, this.color3, (float)(cClockwiseDist - lightRange) / (float)mediumRange);
        }
        return this.color3;
    }

    private static int blend(int c1, int c2, float t) {
        int a1 = c1 >>> 24;
        int r1 = c1 >>> 16 & 0xFF;
        int g1 = c1 >>> 8 & 0xFF;
        int b1 = c1 & 0xFF;
        int a2 = c2 >>> 24;
        int r2 = c2 >>> 16 & 0xFF;
        int g2 = c2 >>> 8 & 0xFF;
        int b2 = c2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * t);
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int mod(int x, int m) {
        int ret = x % m;
        return ret < 0 ? ret + m : ret;
    }

    private static int clamp(int value) {
        return Math.max(2, Math.min(24, value));
    }
}

