/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.tooltipoverhaul.client.frame;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameConfig;
import dev.xylonity.tooltipoverhaul.client.frame.CustomFrameData;
import java.lang.reflect.Type;
import java.util.List;

public class CustomFrameConfigDeserializer
implements JsonDeserializer<CustomFrameConfig> {
    public CustomFrameConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) {
        if (!json.isJsonObject()) {
            throw new JsonParseException("Expected JSON object for CustomFrameConfig");
        }
        JsonObject file = json.getAsJsonObject();
        if (!file.has("frames") || !file.get("frames").isJsonArray()) {
            return new CustomFrameConfig(List.of());
        }
        List<CustomFrameData> frames = file.getAsJsonArray("frames").asList().stream().map(element -> (CustomFrameData)context.deserialize(element, CustomFrameData.class)).toList();
        return new CustomFrameConfig(frames);
    }
}

