/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.common.impl.client.tips.conditions;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.common.api.data.codecs.map.MapCodecs;
import net.darkhax.tipsmod.common.impl.client.tips.conditions.IRuleBuilder;

public record RuleGroup<T>(List<Predicate<T>> predicates, Set<String> rawRules) {
    public boolean anyMatch(T t) {
        return this.predicates.stream().anyMatch(rule -> rule.test(t));
    }

    public boolean allMatch(T t) {
        return this.predicates.stream().allMatch(rule -> rule.test(t));
    }

    public boolean noneMatch(T t) {
        return this.predicates.stream().noneMatch(rule -> rule.test(t));
    }

    public static <T> Codec<RuleGroup<T>> codecOf(IRuleBuilder<T> ruleBuilder) {
        return MapCodecs.STRING.getSet().xmap(to -> new RuleGroup(to.stream().map(ruleBuilder::build).collect(Collectors.toList()), (Set<String>)to), from -> from.rawRules);
    }
}

