/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.tesseract.integration;

import com.supermartijn642.core.TextComponents;
import com.supermartijn642.tesseract.EnumChannelType;
import com.supermartijn642.tesseract.TesseractBlock;
import com.supermartijn642.tesseract.TesseractBlockEntity;
import com.supermartijn642.tesseract.manager.Channel;
import com.supermartijn642.tesseract.manager.TesseractChannelManager;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IClientRegistrar;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.IWailaClientPlugin;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TesseractWTHITPlugin
implements IBlockComponentProvider,
IWailaClientPlugin {
    public void register(IClientRegistrar registration) {
        registration.body((IBlockComponentProvider)this, TesseractBlock.class);
        registration.body(new IBlockComponentProvider(this){

            public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
                tooltip.setLine(ResourceLocation.parse((String)"wailax:energy"));
                tooltip.setLine(ResourceLocation.parse((String)"wailax:fluid"));
                tooltip.setLine(ResourceLocation.parse((String)"wailax:item"));
            }
        }, TesseractBlockEntity.class, 2000);
    }

    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        BlockEntity entity = accessor.getBlockEntity();
        if (entity instanceof TesseractBlockEntity) {
            TesseractBlockEntity tesseract = (TesseractBlockEntity)entity;
            tooltip.addLine((Component)TextComponents.translation((String)"tesseract.tesseract.highlight.channels").get());
            tooltip.addLine(TesseractWTHITPlugin.formatChannelInfo(EnumChannelType.ITEMS, tesseract.getChannelId(EnumChannelType.ITEMS)));
            tooltip.addLine(TesseractWTHITPlugin.formatChannelInfo(EnumChannelType.ENERGY, tesseract.getChannelId(EnumChannelType.ENERGY)));
            tooltip.addLine(TesseractWTHITPlugin.formatChannelInfo(EnumChannelType.FLUID, tesseract.getChannelId(EnumChannelType.FLUID)));
            if (tesseract.isBlockedByRedstone()) {
                tooltip.addLine((Component)TextComponents.translation((String)"tesseract.tesseract.highlight.redstone_blocked").color(ChatFormatting.RED).get());
            }
        }
    }

    private static Component formatChannelInfo(EnumChannelType type, int channelId) {
        Channel channel = TesseractChannelManager.CLIENT.getChannelById(type, channelId);
        MutableComponent channelType = TextComponents.fromTextComponent((Component)type.getTranslation()).color(ChatFormatting.GOLD).get();
        MutableComponent separator = TextComponents.translation((String)"tesseract.tesseract.highlight.channel_info.separator").get();
        MutableComponent channelName = channel == null ? TextComponents.translation((String)"tesseract.tesseract.highlight.channel_info.inactive").color(ChatFormatting.DARK_GRAY).italic().get() : TextComponents.string((String)channel.name).get();
        return TextComponents.translation((String)"tesseract.tesseract.highlight.channel_info", (Object[])new Object[]{channelType, separator, channelName}).get();
    }
}

