/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items.crafting;

import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.common.items.FlagItem;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModRecipes;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class FlagFromBannerRecipe
extends CustomRecipe {
    public FlagFromBannerRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput inv, Level world) {
        DyeColor dyecolor = null;
        ItemStack withPatterns = null;
        ItemStack empty = null;
        for (int i = 0; i < inv.size(); ++i) {
            int j;
            BannerPatternLayers patterns;
            ItemStack itemStack = inv.getItem(i);
            Item item = itemStack.getItem();
            if (item instanceof FlagItem) {
                FlagItem flagItem = (FlagItem)item;
                if (dyecolor == null) {
                    dyecolor = flagItem.getColor();
                } else if (dyecolor != flagItem.getColor()) {
                    return false;
                }
                patterns = (BannerPatternLayers)itemStack.get(DataComponents.BANNER_PATTERNS);
                j = patterns.layers().size();
                if (j > FlagFromBannerRecipe.getMaxBannerPatterns()) {
                    return false;
                }
                if (j > 0) {
                    if (withPatterns != null) {
                        return false;
                    }
                    withPatterns = itemStack;
                    continue;
                }
                if (empty != null) {
                    return false;
                }
                empty = itemStack;
                continue;
            }
            if (item instanceof BannerItem) {
                BannerItem banneritem = (BannerItem)item;
                if (dyecolor == null) {
                    dyecolor = banneritem.getColor();
                } else if (dyecolor != banneritem.getColor()) {
                    return false;
                }
                patterns = (BannerPatternLayers)itemStack.get(DataComponents.BANNER_PATTERNS);
                j = patterns.layers().size();
                if (j > FlagFromBannerRecipe.getMaxBannerPatterns()) {
                    return false;
                }
                if (!(j <= 0 || empty != null && empty.getItem() instanceof BannerItem)) {
                    if (withPatterns != null) {
                        return false;
                    }
                    withPatterns = itemStack;
                    continue;
                }
                if (withPatterns != null && withPatterns.getItem() instanceof BannerItem) continue;
                if (empty != null) {
                    return false;
                }
                empty = itemStack;
                continue;
            }
            if (itemStack.isEmpty()) continue;
            return false;
        }
        return withPatterns != null && empty != null;
    }

    private static int getMaxBannerPatterns() {
        return CompatHandler.QUARK ? QuarkCompat.getBannerPatternLimit(6) : 6;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider access) {
        for (int i = 0; i < inv.size(); ++i) {
            BannerPatternLayers patterns;
            ItemStack withPatterns = inv.getItem(i);
            if (withPatterns.isEmpty() || (patterns = (BannerPatternLayers)withPatterns.get(DataComponents.BANNER_PATTERNS)) != null && patterns.layers().isEmpty()) continue;
            for (int k = 0; k < inv.size(); ++k) {
                ItemStack empty;
                Item it;
                if (i == k || !((it = (empty = inv.getItem(k)).getItem()) instanceof FlagItem) && !(it instanceof BannerItem)) continue;
                ItemStack result = empty.copy();
                result.setCount(1);
                result.set(DataComponents.BANNER_PATTERNS, (Object)patterns);
                return result;
            }
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList stacks = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack itemstack = inv.getItem(i);
            if (itemstack.isEmpty()) continue;
            Optional container = ForgeHelper.getCraftingRemainingItem((ItemStack)itemstack);
            if (container.isPresent()) {
                stacks.set(i, (Object)((ItemStack)container.get()));
                continue;
            }
            BannerPatternLayers patterns = (BannerPatternLayers)itemstack.get(DataComponents.BANNER_PATTERNS);
            if (patterns == null || patterns.layers().isEmpty()) continue;
            stacks.set(i, (Object)itemstack.copyWithCount(1));
        }
        return stacks;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.FLAG_FROM_BANNER.get();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }
}

