/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.structures_tweaker.data;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class StructureBlocksData
extends SavedData {
    private final Map<ResourceLocation, Set<BlockPos>> playerPlacedBlocks = new HashMap<ResourceLocation, Set<BlockPos>>();
    private final Map<BlockPos, ResourceLocation> posToStructure = new HashMap<BlockPos, ResourceLocation>();

    public static StructureBlocksData get(ServerLevel level) {
        DimensionDataStorage storage = level.getDataStorage();
        return (StructureBlocksData)storage.computeIfAbsent(new SavedData.Factory(StructureBlocksData::new, (tag, provider) -> StructureBlocksData.load(tag), null), "structures_tweaker_player_blocks");
    }

    private static StructureBlocksData load(CompoundTag tag) {
        StructureBlocksData data = new StructureBlocksData();
        CompoundTag structuresTag = tag.getCompound("player_placed_blocks");
        for (String key : structuresTag.getAllKeys()) {
            ResourceLocation structureId = ResourceLocation.tryParse((String)key);
            if (structureId == null) continue;
            ListTag positions = structuresTag.getList(key, 10);
            HashSet<BlockPos> blocks = new HashSet<BlockPos>();
            for (int i = 0; i < positions.size(); ++i) {
                CompoundTag posTag = positions.getCompound(i);
                BlockPos pos = BlockPos.of((long)posTag.getLong("pos"));
                blocks.add(pos);
                data.posToStructure.put(pos, structureId);
            }
            data.playerPlacedBlocks.put(structureId, blocks);
        }
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        CompoundTag structuresTag = new CompoundTag();
        this.playerPlacedBlocks.forEach((id, positions) -> {
            ListTag positionsTag = new ListTag();
            positions.forEach(pos -> {
                CompoundTag posTag = new CompoundTag();
                posTag.putLong("pos", pos.asLong());
                positionsTag.add((Object)posTag);
            });
            structuresTag.put(id.toString(), (Tag)positionsTag);
        });
        tag.put("player_placed_blocks", (Tag)structuresTag);
        return tag;
    }

    public void addPlayerBlock(ResourceLocation structureId, BlockPos pos) {
        this.playerPlacedBlocks.computeIfAbsent(structureId, k -> new HashSet()).add(pos);
        this.posToStructure.put(pos, structureId);
        this.setDirty();
    }

    public void removePlayerBlock(BlockPos pos) {
        Set<BlockPos> blocks;
        ResourceLocation structureId = this.posToStructure.remove(pos);
        if (structureId != null && (blocks = this.playerPlacedBlocks.get(structureId)) != null) {
            blocks.remove(pos);
            if (blocks.isEmpty()) {
                this.playerPlacedBlocks.remove(structureId);
            }
            this.setDirty();
        }
    }

    public boolean isPlayerPlaced(BlockPos pos) {
        return this.posToStructure.containsKey(pos);
    }

    public void clearStructure(ResourceLocation structureId) {
        Set<BlockPos> blocks = this.playerPlacedBlocks.remove(structureId);
        if (blocks != null) {
            blocks.forEach(this.posToStructure::remove);
            this.setDirty();
        }
    }
}

