/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.structures_tweaker.config.migration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.leclowndu93150.structures_tweaker.config.core.ModularStructureConfig;
import com.leclowndu93150.structures_tweaker.config.presets.StructureConfigPresets;
import com.leclowndu93150.structures_tweaker.config.properties.ConfigRegistry;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModularConfigMigration {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void migrateAllConfigs(Path configDir) {
        try {
            if (!Files.exists(configDir, new LinkOption[0])) {
                return;
            }
            Path globalConfigPath = configDir.resolve("global.json");
            if (Files.exists(globalConfigPath, new LinkOption[0])) {
                ModularConfigMigration.migrateConfig(globalConfigPath);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error during config migration: {}", (Object)e.getMessage());
        }
    }

    private static void migrateConfig(Path configPath) {
        try {
            String content = Files.readString(configPath);
            JsonObject json = JsonParser.parseString((String)content).getAsJsonObject();
            JsonObject configObject = ModularConfigMigration.extractConfigObject(json);
            ArrayList<String> existingProperties = new ArrayList<String>();
            if (json.has("registeredProperties") && json.get("registeredProperties").isJsonArray()) {
                JsonArray props = json.getAsJsonArray("registeredProperties");
                for (JsonElement prop : props) {
                    existingProperties.add(prop.getAsString());
                }
            }
            ModularStructureConfig config = ModularStructureConfig.fromJson(configObject);
            List<String> currentProperties = ConfigRegistry.getPropertyKeys();
            ArrayList<String> newProperties = new ArrayList<String>();
            ArrayList<String> obsoleteProperties = new ArrayList<String>();
            boolean needsUpdate = false;
            for (String prop : currentProperties) {
                if (existingProperties.contains(prop) && configObject.has(prop)) continue;
                newProperties.add(prop);
                needsUpdate = true;
            }
            for (String key : configObject.keySet()) {
                if (currentProperties.contains(key)) continue;
                obsoleteProperties.add(key);
                needsUpdate = true;
            }
            if (needsUpdate) {
                config.applyMissingDefaults();
                ConfigWrapper wrapper = new ConfigWrapper(config);
                Files.writeString(configPath, (CharSequence)GSON.toJson((Object)wrapper), new OpenOption[0]);
                if (!newProperties.isEmpty()) {
                    LOGGER.info("Migrated config {} - added new properties: {}", (Object)configPath, newProperties);
                }
                if (!obsoleteProperties.isEmpty()) {
                    LOGGER.info("Cleaned config {} - removed obsolete properties: {}", (Object)configPath, obsoleteProperties);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to migrate config {}: {}", (Object)configPath, (Object)e.getMessage());
        }
        catch (JsonSyntaxException e) {
            LOGGER.error("Invalid JSON in config {}: {}", (Object)configPath, (Object)e.getMessage());
        }
    }

    public static ModularStructureConfig loadOrCreateConfig(Path configPath, String modId, String structureId) {
        ModularStructureConfig preset;
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                String content = Files.readString(configPath);
                JsonObject json = JsonParser.parseString((String)content).getAsJsonObject();
                if (json.has("individualOverrides") && json.get("individualOverrides").isJsonObject()) {
                    JsonObject overrides = json.getAsJsonObject("individualOverrides");
                    return ModularStructureConfig.fromJson(overrides, false);
                }
                JsonObject configObject = ModularConfigMigration.extractConfigObject(json);
                ModularStructureConfig config = ModularStructureConfig.fromJson(configObject);
                return config;
            }
            catch (JsonSyntaxException | IOException e) {
                LOGGER.error("Failed to load config {}: {}", (Object)configPath, (Object)e.getMessage());
            }
        }
        if ((preset = StructureConfigPresets.getPreset(modId, structureId)) != null) {
            return preset;
        }
        return new ModularStructureConfig();
    }

    private static JsonObject extractConfigObject(JsonObject json) {
        JsonObject config;
        JsonElement configElement;
        if (json.has("config") && (configElement = json.get("config")).isJsonObject() && ((config = configElement.getAsJsonObject()).has("canBreakBlocks") || config.has("canInteract") || config.has("allowItemPickup") || config.has("allowElytraFlight"))) {
            return config;
        }
        if (json.has("configVersion")) {
            JsonObject result = new JsonObject();
            for (Map.Entry entry : json.entrySet()) {
                String key = (String)entry.getKey();
                if (key.equals("configVersion") || key.equals("config") || key.equals("registeredProperties")) continue;
                result.add(key, (JsonElement)entry.getValue());
            }
            return result;
        }
        return json;
    }

    public static class ConfigWrapper {
        private final List<String> registeredProperties = ConfigRegistry.getPropertyKeys();
        private final JsonObject config;

        public ConfigWrapper(ModularStructureConfig config) {
            this.config = config.toJson();
        }
    }
}

