/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.structures_tweaker.command;

import com.leclowndu93150.structures_tweaker.StructuresTweaker;
import com.leclowndu93150.structures_tweaker.config.core.StructureConfigManager;
import com.leclowndu93150.structures_tweaker.config.properties.ConfigProperty;
import com.leclowndu93150.structures_tweaker.config.properties.ConfigRegistry;
import com.leclowndu93150.structures_tweaker.data.DefeatedStructuresData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class ServerCommands {
    private static StructureConfigManager configManager;
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_STRUCTURES;
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_CURRENT_STRUCTURE;
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_CONFIG_PROPERTIES;

    public static void setConfigManager(StructureConfigManager manager) {
        configManager = manager;
    }

    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        ServerCommands.registerDefeatCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ServerCommands.registerConfigCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    private static void registerDefeatCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"structuretweaker").then(((LiteralArgumentBuilder)Commands.literal((String)"defeat").requires(source -> source.hasPermission(2))).executes(context -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
            BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition());
            boolean found = false;
            Registry registry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
            for (Structure structure : registry) {
                StructureStart reference;
                ResourceLocation id = registry.getKey((Object)structure);
                if (id == null || !(reference = level.structureManager().getStructureAt(pos, structure)).isValid()) continue;
                DefeatedStructuresData data = DefeatedStructuresData.get(level);
                data.markDefeated(id, reference.getBoundingBox());
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Structure " + String.valueOf(id) + " marked as defeated!")), true);
                found = true;
                break;
            }
            if (!found) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"No structure found at your position"));
            }
            return 1;
        })));
    }

    private static void registerConfigCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.literal((String)"structuretweaker").then(Commands.literal((String)"config").then(((LiteralArgumentBuilder)Commands.literal((String)"set").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"structure", (ArgumentType)ResourceKeyArgument.key((ResourceKey)Registries.STRUCTURE)).then(Commands.argument((String)"property", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_CONFIG_PROPERTIES).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ServerCommands::executeConfigSet)))))));
    }

    private static int executeConfigSet(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        if (configManager == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Config manager not initialized!"));
            return 0;
        }
        ResourceKey structureKey = ResourceKeyArgument.getStructure(context, (String)"structure").key();
        ResourceLocation structureId = structureKey.location();
        String propertyKey = StringArgumentType.getString(context, (String)"property");
        String valueStr = StringArgumentType.getString(context, (String)"value");
        ConfigProperty<?> property = ConfigRegistry.getProperty(propertyKey);
        if (property == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Unknown property: " + propertyKey)));
            return 0;
        }
        try {
            Object parsedValue = ServerCommands.parseValue(valueStr, property.getType());
            if (parsedValue == null) {
                ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Invalid value '" + valueStr + "' for property type " + property.getType().getSimpleName())));
                return 0;
            }
            boolean success = configManager.setConfigValue(structureId, propertyKey, parsedValue);
            if (success) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Set " + String.valueOf(structureId) + " > " + propertyKey + " = " + valueStr)), true);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Failed to save config for " + String.valueOf(structureId))));
            return 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)("Error setting config: " + e.getMessage())));
            StructuresTweaker.LOGGER.error("Error setting config", (Throwable)e);
            return 0;
        }
    }

    private static Object parseValue(String valueStr, Class<?> type) {
        if (type == Boolean.class) {
            if ("true".equalsIgnoreCase(valueStr)) {
                return true;
            }
            if ("false".equalsIgnoreCase(valueStr)) {
                return false;
            }
            return null;
        }
        if (type == Integer.class) {
            try {
                return Integer.parseInt(valueStr);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (type == String.class) {
            return valueStr;
        }
        if (type == List.class) {
            ArrayList<String> list = new ArrayList<String>();
            for (String item : valueStr.split(",")) {
                list.add(item.trim());
            }
            return list;
        }
        return null;
    }

    static {
        SUGGEST_STRUCTURES = (context, builder) -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
            Registry registry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
            Stream<String> structureIds = registry.keySet().stream().map(ResourceLocation::toString);
            return SharedSuggestionProvider.suggest(structureIds, (SuggestionsBuilder)builder);
        };
        SUGGEST_CURRENT_STRUCTURE = (context, builder) -> {
            ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
            BlockPos pos = BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition());
            Registry registry = level.registryAccess().registryOrThrow(Registries.STRUCTURE);
            ArrayList<String> nearbyStructures = new ArrayList<String>();
            for (Structure structure : registry) {
                StructureStart reference;
                ResourceLocation id = registry.getKey((Object)structure);
                if (id == null || !(reference = level.structureManager().getStructureAt(pos, structure)).isValid()) continue;
                nearbyStructures.add(id.toString());
            }
            return SharedSuggestionProvider.suggest(nearbyStructures, (SuggestionsBuilder)builder);
        };
        SUGGEST_CONFIG_PROPERTIES = (context, builder) -> {
            Stream propertyKeys = ConfigRegistry.getAllProperties().keySet().stream();
            return SharedSuggestionProvider.suggest(propertyKeys, (SuggestionsBuilder)builder);
        };
    }
}

