/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.statuseffectbars.config;

import com.leclowndu93150.statuseffectbars.config.ColorMode;
import com.leclowndu93150.statuseffectbars.config.Direction;
import net.minecraft.world.effect.MobEffectInstance;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class StatusEffectBarsConfig {
    public static final ModConfigSpec SPEC;
    public static final StatusEffectBarsConfig INSTANCE;
    public final ModConfigSpec.EnumValue<ColorMode> colorMode;
    public final ModConfigSpec.IntValue backgroundColor;
    public final ModConfigSpec.IntValue beneficialForegroundColor;
    public final ModConfigSpec.IntValue harmfulForegroundColor;
    public final ModConfigSpec.IntValue neutralForegroundColor;
    public final ModConfigSpec.IntValue maxRemainingDuration;
    public final ModConfigSpec.IntValue minAmbientAge;
    public final ModConfigSpec.BooleanValue renderOldTimer;
    public final ModConfigSpec.BooleanValue renderCustomTimer;
    public final LayoutConfig hudLayout;
    public final LayoutConfig inventoryLayout;

    public StatusEffectBarsConfig(ModConfigSpec.Builder builder) {
        builder.push("color");
        this.colorMode = builder.comment(new String[]{"Color mode for status effect bars", "EFFECT_COLOR: Use the color of the status effect", "CUSTOM: Use custom colors defined below", "CATEGORY: Use colors based on effect category (beneficial/harmful/neutral)"}).translation("statuseffectbars.configuration.colorMode").defineEnum("colorMode", (Enum)ColorMode.EFFECT_COLOR);
        this.backgroundColor = builder.comment("Background color of the bars (ARGB format)").translation("statuseffectbars.configuration.backgroundColor").defineInRange("backgroundColor", Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.beneficialForegroundColor = builder.comment("Foreground color for beneficial effects (ARGB format)").translation("statuseffectbars.configuration.beneficialForegroundColor").defineInRange("beneficialForegroundColor", -2130706433, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.harmfulForegroundColor = builder.comment("Foreground color for harmful effects (ARGB format)").translation("statuseffectbars.configuration.harmfulForegroundColor").defineInRange("harmfulForegroundColor", -2130706433, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.neutralForegroundColor = builder.comment("Foreground color for neutral effects (ARGB format)").translation("statuseffectbars.configuration.neutralForegroundColor").defineInRange("neutralForegroundColor", -2130706433, Integer.MIN_VALUE, Integer.MAX_VALUE);
        builder.pop();
        builder.push("behavior");
        this.maxRemainingDuration = builder.comment(new String[]{"Remaining duration in ticks above which the bar is hidden", "Set to 2147483647 (max int) to never hide bars based on duration"}).translation("statuseffectbars.configuration.maxRemainingDuration").defineInRange("maxRemainingDuration", Integer.MAX_VALUE, 0, Integer.MAX_VALUE);
        this.minAmbientAge = builder.comment(new String[]{"Age in ticks under which the bar of ambient (i.e. beacon) effects is hidden", "Default is 90 ticks (80 + 10)"}).translation("statuseffectbars.configuration.minAmbientAge").defineInRange("minAmbientAge", 90, 0, Integer.MAX_VALUE);
        this.renderOldTimer = builder.comment(new String[]{"Render the original Stylish Effects timer", "When false, the original timer is hidden"}).translation("statuseffectbars.configuration.renderOldTimer").define("renderOldTimer", false);
        this.renderCustomTimer = builder.comment(new String[]{"Render the custom timer for status effect bars when Stylish Effects is installed.", "When true, renders a smaller duration text at the top left of effects"}).translation("statuseffectbars.configuration.renderCustomTimer").define("renderCustomTimer", true);
        builder.pop();
        builder.push("layout");
        this.hudLayout = new LayoutConfig(builder, "hud", 3, 2);
        this.inventoryLayout = new LayoutConfig(builder, "inventory", 4, 3);
        builder.pop();
    }

    public int getColor(MobEffectInstance effect) {
        return ((ColorMode)((Object)this.colorMode.get())).getColor(this, effect);
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(StatusEffectBarsConfig::new);
        INSTANCE = (StatusEffectBarsConfig)pair.getLeft();
        SPEC = (ModConfigSpec)pair.getRight();
    }

    public static class LayoutConfig {
        public final ModConfigSpec.BooleanValue enabled;
        public final ModConfigSpec.EnumValue<Direction> direction;
        public final ModConfigSpec.BooleanValue relativeToEnd;
        public final ModConfigSpec.IntValue thickness;
        public final ModConfigSpec.IntValue collinearPadding;
        public final ModConfigSpec.IntValue collinearOffset;
        public final ModConfigSpec.IntValue orthogonalOffset;

        public LayoutConfig(ModConfigSpec.Builder builder, String name, int defaultCollinearPadding, int defaultOrthogonalOffset) {
            builder.push(name);
            this.enabled = builder.comment("Enable status effect bars in " + name).translation("statuseffectbars.configuration." + name + ".enabled").define("enabled", true);
            builder.push("position");
            this.direction = builder.comment("Direction of the bar").translation("statuseffectbars.configuration." + name + ".direction").defineEnum("direction", (Enum)Direction.LEFT_TO_RIGHT);
            this.relativeToEnd = builder.comment(new String[]{"Whether the bar is placed relative to the end (bottom/right)", "or the start (top/left) of the effect rectangle"}).translation("statuseffectbars.configuration." + name + ".relativeToEnd").define("relativeToEnd", true);
            builder.pop().push("shape");
            this.thickness = builder.comment("Thickness of the bar in pixels").translation("statuseffectbars.configuration." + name + ".thickness").defineInRange("thickness", 1, 1, 10);
            this.collinearPadding = builder.comment("Padding along the bar's main axis").translation("statuseffectbars.configuration." + name + ".collinearPadding").defineInRange("collinearPadding", defaultCollinearPadding, 0, 20);
            builder.pop().push("fineTuning");
            this.collinearOffset = builder.comment("Offset along the bar's main axis").translation("statuseffectbars.configuration." + name + ".collinearOffset").defineInRange("collinearOffset", 0, -50, 50);
            this.orthogonalOffset = builder.comment("Offset perpendicular to the bar").translation("statuseffectbars.configuration." + name + ".orthogonalOffset").defineInRange("orthogonalOffset", defaultOrthogonalOffset, -50, 50);
            builder.pop().pop();
        }
    }
}

