/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.statuseffectbars.config;

import com.leclowndu93150.statuseffectbars.config.StatusEffectBarsConfig;
import java.util.function.ToIntBiFunction;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;

public enum ColorMode {
    EFFECT_COLOR((config, effect) -> ((MobEffect)effect.getEffect().value()).getColor() | 0xFF000000),
    CATEGORY_COLOR((config, effect) -> ((MobEffect)effect.getEffect().value()).getCategory().getTooltipFormatting().getColor() | 0xFF000000),
    CUSTOM((config, effect) -> switch (((MobEffect)effect.getEffect().value()).getCategory()) {
        case MobEffectCategory.BENEFICIAL -> (Integer)config.beneficialForegroundColor.get();
        case MobEffectCategory.HARMFUL -> (Integer)config.harmfulForegroundColor.get();
        default -> (Integer)config.neutralForegroundColor.get();
    });

    private final ToIntBiFunction<StatusEffectBarsConfig, MobEffectInstance> colorProvider;

    private ColorMode(ToIntBiFunction<StatusEffectBarsConfig, MobEffectInstance> colorProvider) {
        this.colorProvider = colorProvider;
    }

    public int getColor(StatusEffectBarsConfig config, MobEffectInstance effect) {
        return this.colorProvider.applyAsInt(config, effect);
    }

    public String toString() {
        return I18n.get((String)("text.autoconfig.status-effect-bars.option.colorMode." + this.name()), (Object[])new Object[0]);
    }
}

