/*
 * Decompiled with CFR 0.152.
 */
package com.cazsius.solcarrot.tracking;

import com.cazsius.solcarrot.SOLCarrot;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public final class FoodInstance {
    public final Item item;

    public FoodInstance(Item item) {
        this.item = item;
    }

    @Nullable
    public static FoodInstance decode(String encoded) {
        ResourceLocation name = ResourceLocation.tryParse((String)encoded);
        Item item = (Item)BuiltInRegistries.ITEM.get(name);
        if (item == null) {
            SOLCarrot.LOGGER.warn("attempting to load item into food list that is no longer registered: {} (removing from list)", (Object)encoded);
            return null;
        }
        if (item.getDefaultInstance().getFoodProperties(null) == null) {
            SOLCarrot.LOGGER.warn("attempting to load item into food list that is no longer edible: {} (ignoring in case it becomes edible again later)", (Object)encoded);
        }
        return new FoodInstance(item);
    }

    @Nullable
    public String encode() {
        return Optional.ofNullable(BuiltInRegistries.ITEM.getKey((Object)this.item)).map(ResourceLocation::toString).orElse(null);
    }

    public int hashCode() {
        return this.item.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FoodInstance)) {
            return false;
        }
        FoodInstance other = (FoodInstance)obj;
        return this.item.equals(other.item);
    }

    public Item getItem() {
        return this.item;
    }
}

