/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.shield_api.item;

import com.google.common.base.Suppliers;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public class CustomShieldItem
extends ShieldItem {
    private Supplier<ItemAttributeModifiers> attributeModifiers;
    public static final HashSet<CustomShieldItem> instances = new HashSet();
    @Nullable
    private final Holder<SoundEvent> equipSound;
    private final Supplier<Ingredient> repairIngredientSupplier;

    public CustomShieldItem(@Nullable Holder<SoundEvent> equipSound, Supplier<Ingredient> repairIngredientSupplier, List<Tuple<Holder<Attribute>, AttributeModifier>> attributeModifierList, Item.Properties settings) {
        super(settings);
        this.attributeModifiers = this.buildModifiers(attributeModifierList);
        this.equipSound = equipSound;
        this.repairIngredientSupplier = repairIngredientSupplier;
        instances.add(this);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack ingredient) {
        return this.repairIngredientSupplier.get().test(ingredient) || super.isValidRepairItem(stack, ingredient);
    }

    public void setAttributeModifiers(List<Tuple<Holder<Attribute>, AttributeModifier>> attributeModifierList) {
        this.attributeModifiers = this.buildModifiers(attributeModifierList);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.attributeModifiers.get();
    }

    protected Supplier<ItemAttributeModifiers> buildModifiers(List<Tuple<Holder<Attribute>, AttributeModifier>> attributeModifierList) {
        return Suppliers.memoize(() -> {
            ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
            for (Tuple pair : attributeModifierList) {
                builder.add((Holder)pair.getA(), (AttributeModifier)pair.getB(), EquipmentSlotGroup.HAND);
            }
            return builder.build();
        });
    }

    @Nullable
    public Holder<SoundEvent> getEquipSound() {
        return this.equipSound != null ? this.equipSound : super.getEquipSound();
    }

    public Supplier<Ingredient> getRepairIngredientSupplier() {
        return this.repairIngredientSupplier;
    }
}

