/*
 * Decompiled with CFR 0.152.
 */
package net.fabric_extras.shield_api.compat.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.recipe.EmiAnvilRecipe;
import net.fabric_extras.shield_api.item.CustomShieldItem;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

@EmiEntrypoint
public class ShieldAPIEmiPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        for (CustomShieldItem shield : CustomShieldItem.instances) {
            this.registerAnvilRecipe(registry, (Item)shield);
        }
    }

    private void registerAnvilRecipe(EmiRegistry registry, Item item) {
        if (!(item instanceof CustomShieldItem)) {
            return;
        }
        CustomShieldItem shield = (CustomShieldItem)item;
        Ingredient repairIngredient = shield.getRepairIngredientSupplier().get();
        Holder.Reference itemEntry = item.builtInRegistryHolder();
        if (itemEntry == null || itemEntry.unwrapKey().isEmpty()) {
            return;
        }
        ResourceLocation itemId = ((ResourceKey)itemEntry.unwrapKey().get()).location();
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)itemId.getNamespace(), (String)("anvil_repair_shield_api/" + itemId.getPath()));
        EmiStack input = EmiStack.of((ItemLike)item);
        EmiIngredient repairMaterial = EmiIngredient.of((Ingredient)repairIngredient);
        EmiAnvilRecipe recipe = new EmiAnvilRecipe(input, repairMaterial, id);
        registry.addRecipe((EmiRecipe)recipe);
    }
}

