/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.util;

import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.ftb.mods.ftblibrary.icon.Icon;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public final class GuiUtils {
    public static final ResourceLocation MISSING_ICON = ResourceLocation.parse((String)"textures/misc/unknown_server.png");
    public static final Icon MISSING_IMAGE_ICON = Icon.getIcon((ResourceLocation)MISSING_ICON);

    public static boolean shouldProcess(String requiredVariable, VariableStorage variableStorage) {
        if (requiredVariable == null || requiredVariable.isBlank()) {
            return true;
        }
        String[] parts = requiredVariable.split("&");
        if (parts.length == 0) {
            return false;
        }
        for (String part : parts) {
            String partTrimmed = part.trim();
            if (GuiUtils.shouldProcessPart(partTrimmed, variableStorage)) continue;
            return false;
        }
        return true;
    }

    private static boolean shouldProcessPart(String requiredVariable, VariableStorage variableStorage) {
        String str;
        Object value;
        boolean inverted = requiredVariable.startsWith("!");
        if (inverted) {
            requiredVariable = requiredVariable.substring(1);
        }
        if ((value = variableStorage.retrieve(requiredVariable)) instanceof Boolean) {
            Boolean hideElement = (Boolean)value;
            if (inverted) {
                hideElement = hideElement == false;
            }
            return hideElement;
        }
        if (value instanceof String && ((str = (String)value).equalsIgnoreCase("true") || str.equalsIgnoreCase("false"))) {
            boolean hideElement;
            boolean bl = hideElement = !Boolean.parseBoolean(str);
            if (inverted) {
                hideElement = !hideElement;
            }
            return !hideElement;
        }
        if (inverted) {
            return value == null;
        }
        return value != null;
    }

    public static void fillHorizontalGradient(GuiGraphics graphics, RenderType type, int x1, int y1, int x2, int y2, int z, int colorFrom, int colorTo) {
        VertexConsumer consumer = graphics.bufferSource().getBuffer(type);
        float f = (float)FastColor.ARGB32.alpha((int)colorFrom) / 255.0f;
        float g = (float)FastColor.ARGB32.red((int)colorFrom) / 255.0f;
        float h = (float)FastColor.ARGB32.green((int)colorFrom) / 255.0f;
        float i = (float)FastColor.ARGB32.blue((int)colorFrom) / 255.0f;
        float j = (float)FastColor.ARGB32.alpha((int)colorTo) / 255.0f;
        float k = (float)FastColor.ARGB32.red((int)colorTo) / 255.0f;
        float l = (float)FastColor.ARGB32.green((int)colorTo) / 255.0f;
        float m = (float)FastColor.ARGB32.blue((int)colorTo) / 255.0f;
        Matrix4f matrix4f = graphics.pose().last().pose();
        float deltaR = (k - g) / (float)(x2 - x1);
        float deltaG = (l - h) / (float)(x2 - x1);
        float deltaB = (m - i) / (float)(x2 - x1);
        float deltaA = (j - f) / (float)(x2 - x1);
        for (int x = x1; x < x2; ++x) {
            float red = g + deltaR * (float)(x - x1);
            float green = h + deltaG * (float)(x - x1);
            float blue = i + deltaB * (float)(x - x1);
            float alpha = f + deltaA * (float)(x - x1);
            consumer.addVertex(matrix4f, (float)x, (float)y1, (float)z).setColor(red, green, blue, alpha);
            consumer.addVertex(matrix4f, (float)x, (float)y2, (float)z).setColor(red, green, blue, alpha);
            consumer.addVertex(matrix4f, (float)(x + 1), (float)y2, (float)z).setColor(red, green, blue, alpha);
            consumer.addVertex(matrix4f, (float)(x + 1), (float)y1, (float)z).setColor(red, green, blue, alpha);
        }
        RenderSystem.disableDepthTest();
        graphics.bufferSource().endBatch();
        RenderSystem.enableDepthTest();
    }

    public static boolean isImageCached(String id) {
        return Minecraft.getInstance().getTextureManager().getTexture(ResourceLocation.fromNamespaceAndPath((String)"remote_image", (String)Hashing.sha1().hashUnencodedChars((CharSequence)id).toString()), null) != null;
    }

    public static ResourceLocation getOrLoadImage(URI uri) {
        return GuiUtils.getOrLoadImage(uri, null);
    }

    public static ResourceLocation getOrLoadImage(URI uri, @Nullable String id) {
        ResourceLocation location;
        TextureManager textureManager = Minecraft.getInstance().getTextureManager();
        if (textureManager.getTexture(location = ResourceLocation.fromNamespaceAndPath((String)"remote_image", (String)Hashing.sha1().hashUnencodedChars((CharSequence)(id != null ? id : uri.toString())).toString()), null) != null) {
            return location;
        }
        try {
            InputStream stream = uri.toURL().openStream();
            NativeImage nativeImage = NativeImage.read((InputStream)stream);
            DynamicTexture texture = new DynamicTexture(nativeImage);
            textureManager.register(location, (AbstractTexture)texture);
            return location;
        }
        catch (IOException e) {
            RocketClientMod.getLogger().error("Failed to load image from URI: {}", (Object)uri, (Object)e);
            return MISSING_ICON;
        }
    }
}

