/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui.template.element.button.type;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import net.minecraft.client.gui.GuiGraphics;
import net.rocketplatform.game.client.mod.ui.template.callback.ElementCallback;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.button.ButtonTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;
import net.rocketplatform.game.client.mod.ui.variable.VariableStorage;
import org.joml.Vector2i;

public class IconButtonTemplate
extends ButtonTemplate {
    private static final String WIDTH_KEY = "width";
    private static final String HEIGHT_KEY = "height";
    private static final String CENTER_TEXT = "center_text";
    private static final int DEFAULT_WIDTH = 150;
    private static final int DEFAULT_HEIGHT = 20;
    private static final boolean DEFAULT_CENTER_TEXT = true;

    public IconButtonTemplate(String type, String id, ElementTemplate.Position position, ElementCallback callback) {
        super(type, id, position, callback);
    }

    public int getWidth() {
        return this.getOption(WIDTH_KEY, 150);
    }

    public int getHeight() {
        return this.getOption(HEIGHT_KEY, 20);
    }

    public boolean isTextCentered() {
        return this.getOption(CENTER_TEXT, true);
    }

    @Override
    public Widget createElement0(final TemplateScreen screen, int elementWidth, int elementHeight, int offsetX, int offsetY, VariableStorage variableStorage) {
        final int widgetWidth = this.getWidth();
        final int widgetHeight = this.getHeight();
        Vector2i pos = this.getPivot().apply(elementWidth, elementHeight, widgetWidth, widgetHeight);
        pos.add(offsetX + this.getPosition().x(), offsetY + this.getPosition().y());
        Icon buttonIcon = Icon.getIcon((String)this.getIcon());
        final Icon iconBorder = buttonIcon.withBorder(Color4I.BLACK, false);
        final Icon iconBorderHover = buttonIcon.withBorder(Color4I.WHITE, false);
        SimpleTextButton button = new SimpleTextButton(screen.getPanel(), this.getText(), (Icon)Icon.empty()){

            public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                WidgetType widgetType = this.getWidgetType();
                (widgetType == WidgetType.MOUSE_OVER ? iconBorderHover : iconBorder).draw(graphics, x, y, widgetWidth, widgetHeight);
            }

            public void onClicked(MouseButton button) {
                this.playClickSound();
                IconButtonTemplate.this.runCallbacks(screen);
            }

            public boolean renderTitleInCenter() {
                return IconButtonTemplate.this.isTextCentered();
            }
        };
        button.setPosAndSize(pos.x(), pos.y(), widgetWidth, widgetHeight);
        return button;
    }
}

