/*
 * Decompiled with CFR 0.152.
 */
package net.rocketplatform.game.client.mod.ui;

import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import net.minecraft.network.chat.Component;
import net.rocketplatform.game.client.mod.RocketClientMod;
import net.rocketplatform.game.client.mod.ui.FTBWorldsButton;
import net.rocketplatform.game.client.mod.ui.template.element.ElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.element.WidgetElementTemplate;
import net.rocketplatform.game.client.mod.ui.template.layout.screen.TemplateScreen;

public class PromoServerEntry
extends ServerSelectionList.Entry {
    private final Minecraft minecraft = Minecraft.getInstance();
    private final List<ElementTemplate<?>> elements;
    private final List<Widget> buttonWidgets;
    private Screen screen;

    public PromoServerEntry(JoinMultiplayerScreen screen) {
        this.screen = screen;
        this.elements = ElementTemplate.createStandalone("promo_button");
        if (this.elements == null || this.elements.isEmpty()) {
            this.buttonWidgets = new ArrayList<Widget>();
        } else {
            this.buttonWidgets = new ArrayList<Widget>();
            for (ElementTemplate<?> element : this.elements) {
                if (!(element instanceof WidgetElementTemplate)) continue;
                WidgetElementTemplate widgetTemplate = (WidgetElementTemplate)element;
                TemplateScreen templateScreen = TemplateScreen.wrap((Screen)screen, screen.width, screen.height);
                this.buttonWidgets.add((Widget)widgetTemplate.createElement(templateScreen, screen.width, screen.height, 0, 0, templateScreen.getStorage()));
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
        if (this.elements == null) {
            return;
        }
        this.buttonWidgets.clear();
        for (ElementTemplate<?> element : this.elements) {
            if (!(element instanceof WidgetElementTemplate)) continue;
            WidgetElementTemplate widgetTemplate = (WidgetElementTemplate)element;
            TemplateScreen templateScreen = TemplateScreen.wrap(this.minecraft.screen, this.screen.width, this.screen.height);
            this.buttonWidgets.add((Widget)widgetTemplate.createElement(templateScreen, this.screen.width, this.screen.height, left, top, templateScreen.getStorage()));
        }
        for (Widget widget : this.buttonWidgets) {
            widget.draw(guiGraphics, Theme.DEFAULT, widget.posX, widget.posY, width, height);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        FTBWorldsButton.openMainScreen(RocketClientMod.getInstance().getClientHandler());
        return true;
    }

    public Component getNarration() {
        return Component.empty();
    }
}

