/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modulesclient.helper;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.varia.CompositeStreamCodec;
import mcjty.rftoolsbase.api.screens.BarMode;
import mcjty.rftoolsbase.api.screens.FormatStyle;
import mcjty.rftoolsbase.api.screens.ILevelRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsbase.api.screens.data.IModuleDataContents;
import mcjty.rftoolsbase.tools.ScreenTextHelper;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public class ScreenLevelHelper
implements ILevelRenderHelper {
    private boolean hidebar = false;
    private FormatStyle formatStyle = FormatStyle.MODE_FULL;
    private BarMode barMode = BarMode.MODE_TEXT;
    private int poscolor = 0xFFFFFF;
    private int negcolor = 0xFFFFFF;
    private int gradient1 = -65536;
    private int gradient2 = -13421824;
    private String label = "";
    public static final Codec<ScreenLevelHelper> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("hidebar").forGetter(module -> module.hidebar), (App)FormatStyle.CODEC.fieldOf("formatStyle").forGetter(module -> module.formatStyle), (App)BarMode.CODEC.fieldOf("barMode").forGetter(module -> module.barMode), (App)Codec.INT.fieldOf("poscolor").forGetter(module -> module.poscolor), (App)Codec.INT.fieldOf("negcolor").forGetter(module -> module.negcolor), (App)Codec.INT.fieldOf("gradient1").forGetter(module -> module.gradient1), (App)Codec.INT.fieldOf("gradient2").forGetter(module -> module.gradient2), (App)Codec.STRING.fieldOf("label").forGetter(module -> module.label)).apply((Applicative)instance, ScreenLevelHelper::new));
    public static final StreamCodec<FriendlyByteBuf, ScreenLevelHelper> STREAM_CODEC = CompositeStreamCodec.composite((StreamCodec)ByteBufCodecs.BOOL, module -> module.hidebar, (StreamCodec)FormatStyle.STREAM_CODEC, module -> module.formatStyle, (StreamCodec)BarMode.STREAM_CODEC, module -> module.barMode, (StreamCodec)ByteBufCodecs.INT, module -> module.poscolor, (StreamCodec)ByteBufCodecs.INT, module -> module.negcolor, (StreamCodec)ByteBufCodecs.INT, module -> module.gradient1, (StreamCodec)ByteBufCodecs.INT, module -> module.gradient2, (StreamCodec)ByteBufCodecs.STRING_UTF8, module -> module.label, ScreenLevelHelper::new);
    private static DecimalFormat dfCommas = new DecimalFormat("###,###");

    public ScreenLevelHelper(boolean hidebar, FormatStyle formatStyle, BarMode barMode, int poscolor, int negcolor, int gradient1, int gradient2, String label) {
        this.hidebar = hidebar;
        this.formatStyle = formatStyle;
        this.barMode = barMode;
        this.poscolor = poscolor;
        this.negcolor = negcolor;
        this.gradient1 = gradient1;
        this.gradient2 = gradient2;
        this.label = label;
    }

    public ScreenLevelHelper() {
    }

    public void render(GuiGraphics graphics, MultiBufferSource buffer, int x, int y, @Nullable IModuleDataContents data, @Nonnull ModuleRenderInfo renderInfo) {
        if (data == null) {
            return;
        }
        long maxContents = data.getMaxContents();
        if (maxContents > 0L && !this.hidebar) {
            int width;
            long contents = data.getContents();
            long value = contents * (long)(width = 80 - x + 7 + 40) / maxContents;
            if (value < 0L) {
                value = 0L;
            } else if (value > (long)width) {
                value = width;
            }
            RenderHelper.drawHorizontalGradientRect((GuiGraphics)graphics, (MultiBufferSource)buffer, (int)x, (int)y, (int)((int)((long)x + value)), (int)(y + 8), (int)this.gradient1, (int)this.gradient2, (int)renderInfo.getLightmapValue());
        }
        if (!this.barMode.hideText()) {
            String diffTxt = null;
            int col = this.poscolor;
            if (this.barMode.showPerTick()) {
                long diff = data.getLastPerTick();
                if (diff < 0L) {
                    col = this.negcolor;
                    diffTxt = diff + " " + this.label + "/t";
                } else {
                    diffTxt = "+" + diff + " " + this.label + "/t";
                }
            } else if (maxContents > 0L) {
                long contents = data.getContents();
                if (this.barMode.showPercentage()) {
                    long value = contents * 100L / maxContents;
                    if (value < 0L) {
                        value = 0L;
                    } else if (value > 100L) {
                        value = 100L;
                    }
                    diffTxt = value + "%";
                } else {
                    diffTxt = this.format(String.valueOf(contents), this.formatStyle) + this.label;
                }
            }
            if (diffTxt != null) {
                ScreenTextHelper.renderScaled((ResourceLocation)ScreenConfiguration.getTrueTypeFont(), (GuiGraphics)graphics, (MultiBufferSource)buffer, (String)diffTxt, (int)x, (int)y, (int)col, (boolean)renderInfo.truetype, (int)renderInfo.getLightmapValue());
            }
        }
    }

    public ILevelRenderHelper label(String label) {
        this.label = label;
        return this;
    }

    public ILevelRenderHelper settings(boolean hidebar, BarMode barMode) {
        this.hidebar = hidebar;
        this.barMode = barMode;
        return this;
    }

    public ILevelRenderHelper color(int poscolor, int negcolor) {
        this.poscolor = poscolor;
        this.negcolor = negcolor;
        return this;
    }

    public ILevelRenderHelper gradient(int gradient1, int gradient2) {
        this.gradient1 = gradient1;
        this.gradient2 = gradient2;
        return this;
    }

    public ILevelRenderHelper format(FormatStyle formatStyle) {
        this.formatStyle = formatStyle;
        return this;
    }

    public int getPosColor() {
        return this.poscolor;
    }

    public int getNegColor() {
        return this.negcolor;
    }

    public int getGradient1() {
        return this.gradient1;
    }

    public int getGradient2() {
        return this.gradient2;
    }

    public FormatStyle getFormatStyle() {
        return this.formatStyle;
    }

    public boolean isHideBar() {
        return this.hidebar;
    }

    public BarMode getBarMode() {
        return this.barMode;
    }

    public String getLabel() {
        return this.label;
    }

    public void setPosColor(int poscolor) {
        this.poscolor = poscolor;
    }

    public void setNegColor(int negcolor) {
        this.negcolor = negcolor;
    }

    public void setGradient1(int gradient1) {
        this.gradient1 = gradient1;
    }

    public void setGradient2(int gradient2) {
        this.gradient2 = gradient2;
    }

    public void setFormatStyle(FormatStyle formatStyle) {
        this.formatStyle = formatStyle;
    }

    public void setHideBar(boolean hidebar) {
        this.hidebar = hidebar;
    }

    public void setBarMode(BarMode barMode) {
        this.barMode = barMode;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    private String format(String in, FormatStyle style) {
        switch (style) {
            case MODE_FULL: {
                return in;
            }
            case MODE_COMPACT: {
                long contents = Long.parseLong(in);
                int unit = 1000;
                if (contents < (long)unit) {
                    return in;
                }
                int exp = (int)(Math.log(contents) / Math.log(unit));
                char pre = "kMGTPE".charAt(exp - 1);
                return String.format("%.1f %s", (double)contents / Math.pow(unit, exp), Character.valueOf(pre));
            }
            case MODE_COMMAS: {
                return dfCommas.format(Long.parseLong(in));
            }
        }
        return in;
    }
}

