/*
 * Decompiled with CFR 0.152.
 */
package com.respawningstructures.structure;

import com.respawningstructures.RespawningStructures;
import com.respawningstructures.config.CommonConfiguration;
import com.respawningstructures.structure.Respawn;
import com.respawningstructures.structure.RespawnLevelData;
import com.respawningstructures.structure.RespawnManager;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class StructureData {
    public static final StructureData EMPTY = new StructureData(BlockPos.ZERO, ResourceLocation.fromNamespaceAndPath((String)"dummy", (String)"dummy"));
    private static final int DATA_VERSION = 1;
    public final SectionPos pos;
    public final ResourceLocation id;
    private StructureStart structureStart = null;
    public int bbSize = 0;
    public boolean disabledRespawn = false;
    public int spawnerActivations = 0;
    public int spawnerBreak = 0;
    public int containerLooted = 0;
    public int lightsPlaced = 0;
    public int redstonePlaced = 0;
    public int blocksPlaced = 0;
    public int blocksBroken = 0;
    public int mobsKilled = 0;
    public int playerDeaths = 0;
    public int portalUsage = 0;
    public int blockEntities = 0;
    public long inhabitedStart = 0L;
    public long lastActivity = 0L;
    public int respawns = 0;

    public StructureData(BlockPos pos, ResourceLocation id) {
        this.pos = SectionPos.of((BlockPos)pos);
        this.id = id;
    }

    public void setLastModifiedTime(long timepoint) {
        this.lastActivity = timepoint;
    }

    public CompoundTag serializeNbt() {
        CompoundTag tag = new CompoundTag();
        tag.putInt("version", 1);
        tag.putInt("posx", this.pos.getX());
        tag.putInt("posy", this.pos.getY());
        tag.putInt("posz", this.pos.getZ());
        tag.putString("id", this.id.toString());
        tag.putBoolean("disabledRespawn", this.disabledRespawn);
        tag.putInt("spawnerActivations", this.spawnerActivations);
        tag.putInt("bbSize", this.bbSize);
        tag.putInt("spawnerBreak", this.spawnerBreak);
        tag.putInt("portalUsage", this.portalUsage);
        tag.putInt("containerLooted", this.containerLooted);
        tag.putInt("lightsPlaced", this.lightsPlaced);
        tag.putInt("redstonePlaced", this.redstonePlaced);
        tag.putInt("blockEntities", this.blockEntities);
        tag.putLong("inhabitedStart", this.inhabitedStart);
        tag.putInt("blocksPlaced", this.blocksPlaced);
        tag.putInt("blocksBroken", this.blocksBroken);
        tag.putInt("mobsKilled", this.mobsKilled);
        tag.putInt("playerDeaths", this.playerDeaths);
        tag.putInt("respawns", this.respawns);
        tag.putLong("lastActivity", this.lastActivity);
        return tag;
    }

    public StructureData(CompoundTag tag) {
        int version = tag.getInt("version");
        this.pos = SectionPos.of((int)tag.getInt("posx"), (int)tag.getInt("posy"), (int)tag.getInt("posz"));
        this.id = ResourceLocation.tryParse((String)tag.getString("id"));
        this.spawnerActivations = tag.getInt("spawnerActivations");
        this.bbSize = tag.getInt("bbSize");
        this.disabledRespawn = tag.getBoolean("disabledRespawn");
        this.spawnerBreak = tag.getInt("spawnerBreak");
        this.portalUsage = tag.getInt("portalUsage");
        this.containerLooted = tag.getInt("containerLooted");
        this.lightsPlaced = tag.getInt("lightsPlaced");
        if (tag.contains("redstonePlaced")) {
            this.redstonePlaced = tag.getInt("redstonePlaced");
        }
        if (tag.contains("blockEntities")) {
            this.blockEntities = tag.getInt("blockEntities");
        }
        if (tag.contains("inhabitedStart")) {
            this.inhabitedStart = tag.getLong("inhabitedStart");
        }
        this.blocksPlaced = tag.getInt("blocksPlaced");
        this.blocksBroken = tag.getInt("blocksBroken");
        this.mobsKilled = tag.getInt("mobsKilled");
        this.playerDeaths = tag.getInt("playerDeaths");
        this.respawns = tag.getInt("respawns");
        this.lastActivity = tag.getLong("lastActivity");
    }

    public StructureStart fillStructureStart(ServerLevel level) {
        if (this.structureStart != null) {
            return this.structureStart;
        }
        for (Map.Entry entry : level.structureManager().getAllStructuresAt(this.pos.center()).entrySet()) {
            if (!this.id.equals((Object)((Registry)level.registryAccess().registry(Registries.STRUCTURE).get()).getKey((Object)((Structure)entry.getKey())))) continue;
            level.structureManager().fillStartsForStructure((Structure)entry.getKey(), (LongSet)entry.getValue(), structureStart -> {
                if (SectionPos.of((BlockPos)structureStart.getBoundingBox().getCenter()).equals((Object)this.pos)) {
                    this.structureStart = structureStart;
                }
            });
        }
        if (this.structureStart == null) {
            RespawningStructures.LOGGER.warn("Structure: " + String.valueOf(this.id) + " could not be found, disabling respawn");
            this.disabledRespawn = true;
        }
        return this.structureStart;
    }

    public boolean respawn(ServerLevel level) {
        if (this.canRespawn(level) == RespawnStatus.PENDING_RESPAWN) {
            try {
                return RespawnManager.respawnStructure(level, this, true);
            }
            catch (Exception e) {
                RespawningStructures.LOGGER.warn("Error during respawning structure: " + String.valueOf(this.id) + " blacklisting structure type", (Throwable)e);
                ((CommonConfiguration)RespawningStructures.config.getCommonConfig()).blacklistedStructures.add(this.id.toString());
                RespawningStructures.config.save();
            }
        }
        return false;
    }

    public RespawnStatus canRespawn(ServerLevel level) {
        if (!((CommonConfiguration)RespawningStructures.config.getCommonConfig()).enableAutomaticRespawn || this.disabledRespawn) {
            return RespawnStatus.RESPAWN_DISABLED;
        }
        if (((CommonConfiguration)RespawningStructures.config.getCommonConfig()).whitelist && !((CommonConfiguration)RespawningStructures.config.getCommonConfig()).blacklistedStructures.contains(this.id.toString()) || !((CommonConfiguration)RespawningStructures.config.getCommonConfig()).whitelist && ((CommonConfiguration)RespawningStructures.config.getCommonConfig()).blacklistedStructures.contains(this.id.toString())) {
            return RespawnStatus.BLACKLISTED;
        }
        if (this.lastActivity == 0L || ((RespawnLevelData)level.getDataStorage().computeIfAbsent(RespawnLevelData.RESPAWNLEVELDATAFACTORY, "respawningdungeonsdata")).getLevelTime() - this.lastActivity < (long)((CommonConfiguration)RespawningStructures.config.getCommonConfig()).minutesUntilRespawn * 60L) {
            if (this.lastActivity == 0L) {
                return RespawnStatus.UNUSED;
            }
            return RespawnStatus.WAITING_RESPAWN_TIME;
        }
        if (((CommonConfiguration)RespawningStructures.config.getCommonConfig()).respawnableStructureIDs.contains(this.id.toString())) {
            return this.checkStats(level);
        }
        RespawnStatus status = this.checkBlockingStats(level);
        if (status.isBlocked()) {
            return status;
        }
        status = this.checkStats(level);
        if (status == RespawnStatus.PENDING_RESPAWN) {
            ChunkAccess chunk;
            RespawnLevelData levelData = (RespawnLevelData)level.getDataStorage().computeIfAbsent(RespawnLevelData.RESPAWNLEVELDATAFACTORY, "respawningdungeonsdata");
            Iterator<Respawn> iterator = levelData.playerRespawnTracker.values().iterator();
            while (iterator.hasNext()) {
                Respawn respawnData = iterator.next();
                BlockPos center = this.pos.center();
                if (StructureData.dist2D(respawnData.position, center) < ((CommonConfiguration)RespawningStructures.config.getCommonConfig()).playerRespawnDist && levelData.getLevelTime() - respawnData.lastUsageLevelTime < 1814400L) {
                    this.lastActivity = levelData.getLevelTime() - (long)((CommonConfiguration)RespawningStructures.config.getCommonConfig()).minutesUntilRespawn * 60L / 2L;
                    return RespawnStatus.BLOCKED_PORTAL;
                }
                if (levelData.getLevelTime() - respawnData.lastUsageLevelTime <= 1987200L) continue;
                iterator.remove();
            }
            if (this.inhabitedStart != 0L && level.isLoaded(this.pos.origin()) && (double)((chunk = level.getChunk(this.pos.origin())).getInhabitedTime() - this.inhabitedStart) / 20.0 / (double)(levelData.getLevelTime() - 60L - this.lastActivity) > (double)((CommonConfiguration)RespawningStructures.config.getCommonConfig()).playerNearbyTime / 100.0) {
                this.lastActivity = levelData.getLevelTime();
                this.inhabitedStart = chunk.getInhabitedTime();
                return RespawnStatus.BLOCKED_PORTAL;
            }
        }
        return status;
    }

    public RespawnStatus checkStats(ServerLevel level) {
        if (this.spawnerBreak > 0) {
            return RespawnStatus.PENDING_RESPAWN;
        }
        if (this.containerLooted > 0) {
            return RespawnStatus.PENDING_RESPAWN;
        }
        if (this.spawnerActivations * 3 + this.lightsPlaced * 3 + this.blocksPlaced + this.blocksBroken + this.mobsKilled * 4 + this.playerDeaths * 10 > 25 - (((CommonConfiguration)RespawningStructures.config.getCommonConfig()).respawnableStructureIDs.contains(this.id.toString()) ? 15 : 0)) {
            return RespawnStatus.PENDING_RESPAWN;
        }
        return RespawnStatus.UNUSED;
    }

    public RespawnStatus checkBlockingStats(ServerLevel level) {
        if (this.portalUsage > 5) {
            return RespawnStatus.BLOCKED_PORTAL;
        }
        if ((double)this.redstonePlaced * ((CommonConfiguration)RespawningStructures.config.getCommonConfig()).blockCountMod > 10.0) {
            return RespawnStatus.BLOCKED_REDSTONEPLACED;
        }
        if (this.blockEntities > 10) {
            return RespawnStatus.BLOCKED_FOUND_BLOCKENTITIES;
        }
        if ((double)this.blocksBroken * ((CommonConfiguration)RespawningStructures.config.getCommonConfig()).blockCountMod / (double)this.bbSize > 0.15) {
            return RespawnStatus.BLOCKED_BROKENBLOCKS;
        }
        if ((double)this.blocksPlaced * ((CommonConfiguration)RespawningStructures.config.getCommonConfig()).blockCountMod > 200.0 + (double)this.bbSize / 10000.0 && (double)this.blocksBroken * ((CommonConfiguration)RespawningStructures.config.getCommonConfig()).blockCountMod > 200.0 + (double)this.bbSize / 100000.0) {
            RespawnLevelData levelData = (RespawnLevelData)level.getDataStorage().computeIfAbsent(RespawnLevelData.RESPAWNLEVELDATAFACTORY, "respawningdungeonsdata");
            if (levelData.getLevelTime() - this.lastActivity > 5184000L && level.isLoaded(this.pos.center())) {
                this.blocksPlaced = (int)((double)this.blocksPlaced * 0.99);
                this.blocksBroken = (int)((double)this.blocksBroken * 0.99);
            }
            return RespawnStatus.BLOCKED_PLACEDBROKENBLOCKS;
        }
        return RespawnStatus.PENDING_RESPAWN;
    }

    public StructureStart getStructureStart() {
        return this.structureStart;
    }

    public void setStructureStart(StructureStart structureStart) {
        Vec3i length = structureStart.getBoundingBox().getLength();
        this.bbSize = length.getX() * length.getY() * length.getZ();
        this.structureStart = structureStart;
    }

    public void onRespawnReset() {
        ++this.respawns;
        this.spawnerActivations = 0;
        this.spawnerBreak = 0;
        this.containerLooted = 0;
        this.lightsPlaced = 0;
        this.redstonePlaced = 0;
        this.blocksPlaced = 0;
        this.blocksBroken = 0;
        this.mobsKilled = 0;
        this.playerDeaths = 0;
        this.portalUsage = 0;
        this.blockEntities = 0;
        this.inhabitedStart = 0L;
        this.lastActivity = 0L;
    }

    public Component getStats(ServerLevel level) {
        int dist = Integer.MAX_VALUE;
        RespawnLevelData levelData = (RespawnLevelData)level.getDataStorage().computeIfAbsent(RespawnLevelData.RESPAWNLEVELDATAFACTORY, "respawningdungeonsdata");
        Iterator<Respawn> iterator = levelData.playerRespawnTracker.values().iterator();
        while (iterator.hasNext()) {
            Respawn respawnData = iterator.next();
            BlockPos center = this.pos.center();
            if (levelData.getLevelTime() - respawnData.lastUsageLevelTime < 1814400L && StructureData.dist2D(respawnData.position, center) < dist) {
                dist = StructureData.dist2D(respawnData.position, center);
            }
            if (levelData.getLevelTime() - respawnData.lastUsageLevelTime <= 1987200L) continue;
            iterator.remove();
        }
        int inhabitedTimePct = 0;
        if (this.inhabitedStart != 0L) {
            ChunkAccess chunk = level.getChunk(this.pos.origin());
            inhabitedTimePct = (int)((double)(chunk.getInhabitedTime() - this.inhabitedStart) / 20.0 / (double)(levelData.getLevelTime() - 60L - this.lastActivity) * 100.0);
        }
        return Component.literal((String)("Broken blocks: " + this.blocksBroken)).withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)(" Placed blocks: " + this.blocksPlaced)).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)(" lights placed: " + this.lightsPlaced)).withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)(" redstone placed: " + this.redstonePlaced)).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)(" blockentities : " + this.blockEntities)).withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)(" Portal usage: " + this.portalUsage)).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)(" Containers looted: " + this.containerLooted)).withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)(" Mobs killed: " + this.mobsKilled)).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)(" Player deaths: " + this.playerDeaths)).withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)(" Spawner broken: " + this.spawnerBreak)).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)(" Nearest player spawn: " + dist)).withStyle(ChatFormatting.BLUE)).append((Component)Component.literal((String)(" Inhabited time pct: " + inhabitedTimePct)).withStyle(ChatFormatting.WHITE));
    }

    public static int dist2D(BlockPos pos, BlockPos pos2) {
        int xDiff = pos.getX() - pos2.getX();
        int zDiff = pos.getZ() - pos2.getZ();
        return (int)Math.sqrt(xDiff * xDiff + zDiff * zDiff);
    }

    public static enum RespawnStatus {
        UNUSED,
        RESPAWN_DISABLED(true),
        PENDING_RESPAWN,
        BLOCKED_PORTAL(true),
        BLOCKED_PLACEDBROKENBLOCKS(true),
        BLOCKED_BROKENBLOCKS(true),
        BLOCKED_REDSTONEPLACED(true),
        BLACKLISTED(true),
        WAITING_RESPAWN_TIME,
        BLOCKED_FOUND_BLOCKENTITIES(true);

        private final boolean isBLocked;

        private RespawnStatus() {
            this.isBLocked = false;
        }

        private RespawnStatus(boolean blocked) {
            this.isBLocked = blocked;
        }

        public boolean isBlocked() {
            return this.isBLocked;
        }
    }
}

