/*
 * Decompiled with CFR 0.152.
 */
package com.respawningstructures.structure;

import com.respawningstructures.structure.Respawn;
import com.respawningstructures.structure.StructureData;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.saveddata.SavedData;

public class RespawnLevelData
extends SavedData {
    public static final String ID = "respawningdungeonsdata";
    public static SavedData.Factory<RespawnLevelData> RESPAWNLEVELDATAFACTORY = new SavedData.Factory(RespawnLevelData::new, RespawnLevelData::load);
    private final Long2ObjectOpenHashMap<StructureData> structurePositions = new Long2ObjectOpenHashMap();
    private final Set<StructureData> allStructureData = new HashSet<StructureData>();
    public final Map<UUID, Respawn> playerRespawnTracker = new HashMap<UUID, Respawn>();
    private long elapsedTime = 5L;

    public static RespawnLevelData load(CompoundTag tag, HolderLookup.Provider provider) {
        RespawnLevelData data = new RespawnLevelData();
        data.read(tag);
        return data;
    }

    public void read(CompoundTag nbt) {
        this.elapsedTime = nbt.getLong("elapsedTime");
        ListTag list = nbt.getList("Structures", 10);
        for (Tag tag : list) {
            if (!(tag instanceof CompoundTag)) continue;
            StructureData data = new StructureData((CompoundTag)tag);
            this.structurePositions.put(data.pos.asLong(), (Object)data);
            this.allStructureData.add(data);
        }
        if (nbt.contains("playerrespawns")) {
            ListTag respawnList = nbt.getList("playerrespawns", 10);
            for (Tag tag : respawnList) {
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag compoundTag = (CompoundTag)tag;
                Respawn respawn = new Respawn(compoundTag);
                this.playerRespawnTracker.put(respawn.playerUUID, respawn);
            }
        }
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putLong("elapsedTime", this.elapsedTime);
        ListTag list = new ListTag();
        for (StructureData data : this.allStructureData) {
            if (data == StructureData.EMPTY) continue;
            list.add((Object)data.serializeNbt());
        }
        nbt.put("Structures", (Tag)list);
        ListTag respawnList = new ListTag();
        for (Map.Entry<UUID, Respawn> data : this.playerRespawnTracker.entrySet()) {
            if (data == null) continue;
            respawnList.add((Object)data.getValue().toNbt());
        }
        nbt.put("playerrespawns", (Tag)respawnList);
        return nbt;
    }

    public StructureData getForPos(ServerLevel level, BlockPos pos) {
        return this.getForPos(level, pos, true);
    }

    public StructureData getForPos(ServerLevel level, BlockPos pos, boolean update) {
        StructureData alreadyContainedAtPos = (StructureData)this.structurePositions.get(SectionPos.asLong((BlockPos)pos));
        if (alreadyContainedAtPos == StructureData.EMPTY) {
            return null;
        }
        if (alreadyContainedAtPos != null) {
            if (update) {
                alreadyContainedAtPos.setLastModifiedTime(this.elapsedTime);
                this.setDirty(true);
            }
            return alreadyContainedAtPos;
        }
        StructureStart structureStart = RespawnLevelData.getClosestStart(level, pos);
        if (structureStart == null) {
            this.structurePositions.put(SectionPos.asLong((BlockPos)pos), (Object)StructureData.EMPTY);
            return null;
        }
        StructureData data = (StructureData)this.structurePositions.computeIfAbsent(SectionPos.asLong((BlockPos)structureStart.getBoundingBox().getCenter()), p -> {
            StructureData newData = new StructureData(structureStart.getBoundingBox().getCenter(), ((Registry)level.registryAccess().registry(Registries.STRUCTURE).get()).getKey((Object)structureStart.getStructure()));
            newData.inhabitedStart = level.getChunk(newData.pos.x(), newData.pos.z()).getInhabitedTime();
            this.allStructureData.add(newData);
            return newData;
        });
        this.structurePositions.put(SectionPos.asLong((BlockPos)pos), (Object)data);
        this.setDirty(true);
        data.setStructureStart(structureStart);
        if (update) {
            data.setLastModifiedTime(this.elapsedTime);
        }
        return data;
    }

    public static StructureStart getClosestStart(ServerLevel level, BlockPos pos) {
        HashMap<Structure, LongSet> structures = null;
        ChunkPos start = new ChunkPos(pos);
        for (Map.Entry entry : level.structureManager().getAllStructuresAt(new BlockPos(start.x << 4, 0, start.z << 4)).entrySet()) {
            if (structures == null) {
                structures = new HashMap<Structure, LongSet>();
            }
            structures.computeIfAbsent((Structure)entry.getKey(), k -> new LongOpenHashSet((LongCollection)entry.getValue())).addAll((LongCollection)entry.getValue());
        }
        if (structures == null || structures.isEmpty()) {
            for (int x = -2; x < 2; ++x) {
                for (int z = -2; z < 2; ++z) {
                    if (x == 0 && z == 0 || !level.hasChunk(start.x + x, start.z + z)) continue;
                    for (Map.Entry entry : level.structureManager().getAllStructuresAt(new BlockPos(start.x + x << 4, 0, start.z + z << 4)).entrySet()) {
                        if (structures == null) {
                            structures = new HashMap();
                        }
                        structures.computeIfAbsent((Structure)entry.getKey(), k -> new LongOpenHashSet((LongCollection)entry.getValue())).addAll((LongCollection)entry.getValue());
                    }
                }
            }
        }
        if (structures == null || structures.isEmpty()) {
            return null;
        }
        StructureStart[] closest = new StructureStart[1];
        for (Map.Entry structureEntry : structures.entrySet()) {
            level.structureManager().fillStartsForStructure((Structure)structureEntry.getKey(), (LongSet)structureEntry.getValue(), structureStart -> {
                if (pos.equals((Object)structureStart.getBoundingBox().getCenter()) && (closest[0] == null || closest[0].getBoundingBox().getCenter().distSqr((Vec3i)pos) > structureStart.getBoundingBox().getCenter().distSqr((Vec3i)pos))) {
                    closest[0] = structureStart;
                }
                for (StructurePiece piece : structureStart.getPieces()) {
                    if (piece == null || !piece.getBoundingBox().isInside((Vec3i)pos)) continue;
                    if (closest[0] != null && !(closest[0].getBoundingBox().getCenter().distSqr((Vec3i)pos) > structureStart.getBoundingBox().getCenter().distSqr((Vec3i)pos))) break;
                    closest[0] = structureStart;
                    break;
                }
            });
        }
        return closest[0];
    }

    public void increaseTime(int seconds) {
        this.elapsedTime += (long)seconds;
        this.setDirty(true);
    }

    public long getLevelTime() {
        return this.elapsedTime;
    }

    public Set<StructureData> getAllStructureData() {
        return this.allStructureData;
    }
}

