/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.replication_rs2_bridge.client.model;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.leclowndu93150.replication_rs2_bridge.component.MatterComponent;
import com.leclowndu93150.replication_rs2_bridge.component.ModDataComponents;
import com.leclowndu93150.replication_rs2_bridge.util.MatterTypeInfo;
import com.leclowndu93150.replication_rs2_bridge.util.MatterTypeUtil;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import net.neoforged.neoforge.client.RenderTypeGroup;
import net.neoforged.neoforge.client.model.IModelBuilder;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.geometry.StandaloneGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.Nullable;

public record UniversalMatterItemModel(String defaultMatterType) implements IUnbakedGeometry<UniversalMatterItemModel>
{
    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        ResourceLocation textureLoc = this.resolveTexture(this.defaultMatterType);
        TextureAtlasSprite sprite = spriteGetter.apply(new Material(InventoryMenu.BLOCK_ATLAS, textureLoc));
        StandaloneGeometryBakingContext itemContext = StandaloneGeometryBakingContext.builder((IGeometryBakingContext)context).withGui3d(false).withUseBlockLight(false).build(ResourceLocation.fromNamespaceAndPath((String)"replication_rs2_bridge", (String)"universal_matter_override"));
        RenderTypeGroup renderTypes = new RenderTypeGroup(RenderType.translucent(), NeoForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get());
        List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)sprite);
        List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, material -> sprite, (ModelState)modelState);
        IModelBuilder model = IModelBuilder.of((boolean)itemContext.useAmbientOcclusion(), (boolean)itemContext.useBlockLight(), (boolean)itemContext.isGui3d(), (ItemTransforms)context.getTransforms(), (ItemOverrides)new MatterOverrideHandler(overrides, baker, (IGeometryBakingContext)itemContext), (TextureAtlasSprite)sprite, (RenderTypeGroup)renderTypes);
        quads.forEach(arg_0 -> ((IModelBuilder)model).addUnculledFace(arg_0));
        return model.build();
    }

    private ResourceLocation resolveTexture(String matterTypeName) {
        MatterTypeInfo info = MatterTypeUtil.getMatterInfo(matterTypeName);
        if (info != null) {
            return info.texture();
        }
        return ResourceLocation.fromNamespaceAndPath((String)"replication", (String)("gui/mattertypes/" + matterTypeName.toLowerCase()));
    }

    private static class MatterOverrideHandler
    extends ItemOverrides {
        private final Map<String, BakedModel> cache = Maps.newHashMap();
        private final ItemOverrides nested;
        private final ModelBaker baker;
        private final IGeometryBakingContext owner;

        private MatterOverrideHandler(ItemOverrides nested, ModelBaker baker, IGeometryBakingContext owner) {
            this.nested = nested;
            this.baker = baker;
            this.owner = owner;
        }

        @ParametersAreNonnullByDefault
        @Nullable
        public BakedModel resolve(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            BakedModel overridden = this.nested.resolve(originalModel, stack, level, entity, seed);
            if (overridden != originalModel || level == null) {
                return overridden;
            }
            MatterComponent component = (MatterComponent)stack.get((DataComponentType)ModDataComponents.MATTER.get());
            if (component == null) {
                return originalModel;
            }
            String matterTypeName = component.matterTypeName();
            String cacheKey = "matter:" + matterTypeName;
            if (!this.cache.containsKey(cacheKey)) {
                UniversalMatterItemModel unbaked = new UniversalMatterItemModel(matterTypeName);
                BakedModel bakedModel = unbaked.bake(this.owner, this.baker, Material::sprite, (ModelState)BlockModelRotation.X0_Y0, this);
                this.cache.put(cacheKey, bakedModel);
                return bakedModel;
            }
            return this.cache.get(cacheKey);
        }
    }

    public static class Loader
    implements IGeometryLoader<UniversalMatterItemModel> {
        public UniversalMatterItemModel read(JsonObject json, JsonDeserializationContext context) {
            String defaultType = json.has("default_matter") ? json.get("default_matter").getAsString() : "empty";
            return new UniversalMatterItemModel(defaultType);
        }
    }
}

