/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge.item;

import net.minecraft.world.item.Item;
import net.unfamily.repae2bridge.item.MatterItem;

public class CustomMatterItem
extends MatterItem {
    private String matterTypeId;
    private final String itemId;
    private final int cachedColor;

    public CustomMatterItem(Item.Properties properties, String itemId) {
        super(properties);
        this.itemId = itemId;
        this.matterTypeId = null;
        this.cachedColor = CustomMatterItem.calculateColor(itemId);
    }

    public String getItemId() {
        return this.itemId;
    }

    public String getMatterTypeId() {
        return this.matterTypeId;
    }

    public void bindToMatterType(String matterTypeId) {
        this.matterTypeId = matterTypeId;
    }

    public boolean isBound() {
        return this.matterTypeId != null;
    }

    public int getMatterTypeColor() {
        return this.cachedColor;
    }

    private static int calculateColor(String id) {
        int hash = 0;
        for (char c : id.toCharArray()) {
            hash = 31 * hash + c;
        }
        hash = Math.abs(hash);
        int r = 55 + hash % 201;
        int g = 55 + (hash >> 8) % 201;
        int b = 55 + (hash >> 16) % 201;
        return 0xFF000000 | r << 16 | g << 8 | b;
    }
}

