/*
 * Decompiled with CFR 0.152.
 */
package net.unfamily.repae2bridge;

import appeng.api.ids.AECreativeTabIds;
import appeng.api.networking.IInWorldGridNodeHost;
import com.buuz135.replication.block.MatterPipeBlock;
import com.buuz135.replication.network.DefaultMatterNetworkElement;
import com.hrznstudio.titanium.block_network.element.NetworkElementFactory;
import com.hrznstudio.titanium.block_network.element.NetworkElementRegistry;
import com.mojang.logging.LogUtils;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.unfamily.repae2bridge.Config;
import net.unfamily.repae2bridge.RepAE2BridgeCapabilities;
import net.unfamily.repae2bridge.block.ModBlocks;
import net.unfamily.repae2bridge.block.entity.ModBlockEntities;
import net.unfamily.repae2bridge.block.entity.RepAE2BridgeBlockEntity;
import net.unfamily.repae2bridge.component.ModDataComponents;
import net.unfamily.repae2bridge.item.MatterItem;
import net.unfamily.repae2bridge.item.ModItems;
import net.unfamily.repae2bridge.item.UniversalMatterItem;
import org.slf4j.Logger;

@Mod(value="rep_ae2_bridge")
public class RepAE2Bridge {
    public static final String MOD_ID = "rep_ae2_bridge";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final BlockCapability<IInWorldGridNodeHost, Void> IN_WORLD_GRID_NODE_HOST = BlockCapability.createVoid((ResourceLocation)ResourceLocation.parse((String)"ae2:inworld_gridnode_host"), IInWorldGridNodeHost.class);

    public RepAE2Bridge(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::registerCapabilities);
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        LOGGER.info("RepAE2Bridge: Config registered");
        ModItems.registerCustomMatterItems();
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModDataComponents.register(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            boolean ae2Loaded;
            boolean replicationLoaded = ModList.get().isLoaded("replication");
            boolean bl = ae2Loaded = ModList.get().isLoaded("appliedenergistics2") || ModList.get().isLoaded("ae2");
            if (replicationLoaded && ae2Loaded) {
                LOGGER.info("Replication mod is loaded, skipping DefaultMatterNetworkElement registration to avoid conflicts");
            } else {
                try {
                    LOGGER.info("Replication mod not loaded, registering DefaultMatterNetworkElement factory");
                    NetworkElementRegistry.INSTANCE.addFactory(DefaultMatterNetworkElement.ID, (NetworkElementFactory)new DefaultMatterNetworkElement.Factory());
                    LOGGER.info("Replication network integration complete");
                }
                catch (Exception e) {
                    if (e.getMessage() != null && e.getMessage().contains("duplicate")) {
                        LOGGER.info("DefaultMatterNetworkElement factory already registered, using existing registration");
                    }
                    LOGGER.error("Failed to register with Replication network system", (Throwable)e);
                }
            }
        });
        event.enqueueWork(() -> this.registerWithReplicationMod());
        boolean guideMeLoaded = ModList.get().isLoaded("guideme");
        if (guideMeLoaded) {
            LOGGER.info("GuideME detected, guide system will be available");
            event.enqueueWork(() -> this.registerGuideAssociation());
        } else {
            LOGGER.info("GuideME not detected, guide system will not be available");
        }
        LOGGER.info("RepAE2Bridge: Bridge energy consumption set to {} AE/t", (Object)Config.bridgeEnergyConsumption);
    }

    private void registerGuideAssociation() {
        LOGGER.info("Registering guide association for RepAE2Bridge");
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.registerBlock(IN_WORLD_GRID_NODE_HOST, (level, pos, state, be, context) -> {
            if (be instanceof RepAE2BridgeBlockEntity) {
                RepAE2BridgeBlockEntity bridge = (RepAE2BridgeBlockEntity)be;
                return bridge;
            }
            return null;
        }, new Block[]{(Block)ModBlocks.REPAE2BRIDGE.get()});
        RepAE2BridgeCapabilities.register(event);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == AECreativeTabIds.MAIN) {
            event.accept((ItemLike)ModBlocks.REPAE2BRIDGE.get());
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        RepAE2BridgeBlockEntity.setWorldUnloading(false);
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        LOGGER.info("RepAE2Bridge: Server stopping, notifying bridges to prepare for unload");
        RepAE2BridgeBlockEntity.setWorldUnloading(true);
        try {
            LOGGER.info("RepAE2Bridge: Cancelling all pending operations for rapid shutdown");
            RepAE2BridgeBlockEntity.cancelAllPendingOperations();
        }
        catch (Exception e) {
            LOGGER.warn("RepAE2Bridge: Exception during shutdown cleanup, continuing anyway", (Throwable)e);
        }
        LOGGER.info("RepAE2Bridge: All bridges notified of world unload");
    }

    private void registerWithReplicationMod() {
        try {
            MatterPipeBlock.ALLOWED_CONNECTION_BLOCKS.add(block -> block.getClass().getName().contains(MOD_ID));
            LOGGER.debug("Successfully registered mod namespace with Replication");
        }
        catch (NoClassDefFoundError | NullPointerException e) {
            LOGGER.debug("Replication mod not fully initialized yet, skipping connection registration");
        }
        catch (Exception e) {
            LOGGER.error("Error registering with Replication mod: {}", (Object)e.getMessage());
        }
    }

    @EventBusSubscriber(modid="rep_ae2_bridge", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
        }
    }

    @EventBusSubscriber(modid="rep_ae2_bridge", bus=EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public static void onModifyDefaultComponents(ModifyDefaultComponentsEvent event) {
            int MATTER_MAX_STACK_SIZE = 0x3FFFFFFF;
            AtomicInteger modifiedCount = new AtomicInteger(0);
            event.getAllItems().filter(item -> item instanceof MatterItem || item instanceof UniversalMatterItem).forEach(item -> {
                event.modify((ItemLike)item, builder -> builder.set(DataComponents.MAX_STACK_SIZE, (Object)0x3FFFFFFF));
                modifiedCount.incrementAndGet();
                if (Config.enableDebugLogging) {
                    LOGGER.debug("RepAE2Bridge: Set MAX_STACK_SIZE to {} for matter item: {}", (Object)0x3FFFFFFF, (Object)BuiltInRegistries.ITEM.getKey(item));
                }
            });
            LOGGER.info("RepAE2Bridge: Modified MAX_STACK_SIZE for {} matter items to {}", (Object)modifiedCount.get(), (Object)0x3FFFFFFF);
        }
    }
}

