/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.item.relic;

import it.hurts.octostudios.reliquified_twilight_forest.api.ExtraDataDamageSource;
import it.hurts.octostudios.reliquified_twilight_forest.data.loot.LootEntries;
import it.hurts.octostudios.reliquified_twilight_forest.init.DamageTypeRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.init.ItemRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.item.relic.Parasite116Item;
import it.hurts.octostudios.reliquified_twilight_forest.network.ParasiteEvolveParticlePacket;
import it.hurts.octostudios.reliquified_twilight_forest.util.MathButCool;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.network.packets.PacketItemActivation;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import twilightforest.entity.boss.UrGhast;
import twilightforest.init.TFItems;

@EventBusSubscriber
public class Parasite115Item
extends RelicItem {
    public static final String INFECTIONS = "reliquified_twilight_forest:infections";

    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"infectious_bloom").stat(StatData.builder((String)"chance").initialValue(0.075, 0.125).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.36).formatValue(MathButCool::percentageAndRoundSingleDigit).build()).stat(StatData.builder((String)"max_attacks").initialValue(1.0, 3.0).upgradeModifier(UpgradeOperation.ADD, 0.5).formatValue(Math::round).build()).stat(StatData.builder((String)"damage").initialValue(0.5, 1.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.5).formatValue(MathButCool::roundSingleDigit).build()).stat(StatData.builder((String)"drops").initialValue(1.0, 3.0).upgradeModifier(UpgradeOperation.ADD, 1.0).formatValue(Math::round).build()).maxLevel(5).build()).build()).leveling(LevelingData.builder().sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"infectious_bloom").gem(GemShape.SQUARE, GemColor.RED).build()).build()).maxLevel(5).build()).style(StyleData.builder().beams((player, stack) -> {
            float ticks = (float)player.tickCount + Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
            float lerp = (float)(Math.sin(ticks / 10.0f) / 2.0 + 0.5);
            float r = Mth.lerp((float)lerp, (float)237.0f, (float)255.0f) / 255.0f;
            float g = Mth.lerp((float)lerp, (float)28.0f, (float)127.0f) / 255.0f;
            float b = Mth.lerp((float)lerp, (float)36.0f, (float)39.0f) / 255.0f;
            return BeamsData.builder().startColor(new Color(r, g, b, 1.0f).getRGB()).endColor(new Color(r, g, b, 0.0f).getRGB()).build();
        }).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.DARK_TOWER}).build()).build();
    }

    @SubscribeEvent
    public static void attackEntity(LivingDamageEvent.Post e) {
        LivingEntity livingEntity;
        block5: {
            block4: {
                Entity entity;
                if (e.getEntity().level().isClientSide || e.getSource().is(DamageTypeRegistry.INFECTIOUS_BLOOM) || !((entity = e.getSource().getEntity()) instanceof LivingEntity)) break block4;
                livingEntity = (LivingEntity)entity;
                if (e.getEntity() != livingEntity && !(e.getNewDamage() < 1.0f)) break block5;
            }
            return;
        }
        Optional inventory = CuriosApi.getCuriosInventory((LivingEntity)livingEntity);
        if (inventory.isEmpty()) {
            return;
        }
        List foundCurios = ((ICuriosItemHandler)inventory.get()).findCurios(itemStack -> itemStack.getItem() instanceof Parasite115Item);
        LivingEntity victim = e.getEntity();
        CompoundTag persistentData = victim.getPersistentData();
        CompoundTag infections = persistentData.getCompound(INFECTIONS);
        foundCurios.forEach(slotResult -> {
            ItemStack stack = slotResult.stack();
            int id = slotResult.slotContext().index();
            String key = livingEntity.getStringUUID() + "+" + id + "+" + slotResult.slotContext().identifier();
            Item patt0$temp = stack.getItem();
            if (!(patt0$temp instanceof Parasite115Item)) {
                return;
            }
            Parasite115Item relic = (Parasite115Item)patt0$temp;
            CompoundTag infection = null;
            if (infections.contains(key)) {
                infection = infections.getCompound(key);
                int maxAttacks = infection.getInt("max_attacks");
                infection.putInt("ticks_left", 100 + maxAttacks);
            } else if ((double)livingEntity.getRandom().nextFloat() < relic.getStatValue(stack, "infectious_bloom", "chance")) {
                infection = relic.createBloomTag(stack);
                infections.put(key, (Tag)infection);
                relic.spreadRelicExperience(livingEntity, stack, 1);
            }
            if (infection != null) {
                infections.put(key, (Tag)infection);
            }
        });
        persistentData.put(INFECTIONS, (Tag)infections);
    }

    @SubscribeEvent
    public static void effectTick(EntityTickEvent.Post e) {
        LivingEntity livingEntity;
        ServerLevel serverLevel;
        block5: {
            block4: {
                Level level = e.getEntity().level();
                if (!(level instanceof ServerLevel)) break block4;
                serverLevel = (ServerLevel)level;
                level = e.getEntity();
                if (level instanceof LivingEntity && !(livingEntity = (LivingEntity)level).getPersistentData().getCompound(INFECTIONS).isEmpty()) break block5;
            }
            return;
        }
        if (e.getEntity().tickCount % 2 == 0) {
            ParticleOptions particle = ParticleUtils.constructSimpleSpark((Color)Color.RED, (float)0.25f, (int)10, (float)0.8f);
            serverLevel.sendParticles(particle, e.getEntity().getRandomX(0.5), e.getEntity().getRandomY(), e.getEntity().getRandomZ(0.5), 1, 0.0, 0.0, 0.0, 0.0);
        }
        CompoundTag infections = livingEntity.getPersistentData().getCompound(INFECTIONS);
        CompoundTag newInfections = new CompoundTag();
        infections.getAllKeys().forEach(key -> {
            CompoundTag infection = infections.getCompound(key);
            String[] data = key.split("\\+");
            Entity owner = serverLevel.getEntity(UUID.fromString(data[0]));
            double damage = infection.getDouble("damage");
            byte maxDrops = infection.getByte("max_drops");
            int ticksLeft = infection.getInt("ticks_left");
            int maxAttacks = infection.getInt("max_attacks");
            if (--ticksLeft <= maxAttacks && ticksLeft > 0) {
                livingEntity.invulnerableTime = 0;
                livingEntity.hurt((DamageSource)new ExtraDataDamageSource((Holder<DamageType>)livingEntity.level().registryAccess().holderOrThrow(DamageTypeRegistry.INFECTIOUS_BLOOM), owner, owner, new Object[]{maxDrops, data[1], data[2]}), (float)damage);
            }
            if (ticksLeft > 0) {
                infection.putInt("ticks_left", ticksLeft);
                newInfections.put(key, (Tag)infection);
            }
        });
        livingEntity.getPersistentData().put(INFECTIONS, (Tag)newInfections);
    }

    public CompoundTag createBloomTag(ItemStack stack) {
        CompoundTag tag = new CompoundTag();
        int attacksLeft = (int)Math.round(this.getStatValue(stack, "infectious_bloom", "max_attacks"));
        tag.putDouble("damage", this.getStatValue(stack, "infectious_bloom", "damage"));
        tag.putInt("max_attacks", attacksLeft);
        tag.putInt("ticks_left", 100 + attacksLeft);
        tag.putByte("max_drops", (byte)Math.round(this.getStatValue(stack, "infectious_bloom", "drops")));
        return tag;
    }

    @SubscribeEvent
    public static void generateDrops(LivingDeathEvent e) {
        ExtraDataDamageSource source;
        block10: {
            block9: {
                Level level = e.getEntity().level();
                if (!(level instanceof ServerLevel)) break block9;
                ServerLevel serverLevel = (ServerLevel)level;
                level = e.getSource();
                if (level instanceof ExtraDataDamageSource && (source = (ExtraDataDamageSource)level).is(DamageTypeRegistry.INFECTIOUS_BLOOM)) break block10;
            }
            return;
        }
        byte maxDrops = (Byte)source.getExtra()[0];
        int index = Integer.parseInt((String)source.getExtra()[1]);
        String identifier = (String)source.getExtra()[2];
        Entity owner = source.getEntity();
        if (!(owner instanceof LivingEntity)) {
            return;
        }
        LivingEntity sourceEntity = (LivingEntity)owner;
        ICuriosItemHandler inventory = CuriosApi.getCuriosInventory((LivingEntity)sourceEntity).orElse(null);
        if (inventory == null) {
            return;
        }
        SlotResult result = inventory.findCurio(identifier, index).orElse(null);
        if (result == null) {
            return;
        }
        ItemStack stack = result.stack();
        Item item = stack.getItem();
        if (!(item instanceof Parasite115Item)) {
            return;
        }
        Parasite115Item relic = (Parasite115Item)item;
        Vec3 pos = e.getEntity().position();
        for (int i = 0; i < e.getEntity().getRandom().nextIntBetweenInclusive(1, (int)maxDrops); ++i) {
            Vec3 dropVec = new Vec3((double)((e.getEntity().getRandom().nextFloat() - 0.5f) / 3.0f), 0.5, (double)((e.getEntity().getRandom().nextFloat() - 0.5f) / 3.0f));
            ItemEntity toDrop = new ItemEntity(e.getEntity().level(), pos.x, pos.y, pos.z, TFItems.EXPERIMENT_115.toStack(), dropVec.x, dropVec.y, dropVec.z);
            toDrop.setNoPickUpDelay();
            e.getEntity().level().addFreshEntity((Entity)toDrop);
        }
        if (e.getEntity() instanceof UrGhast && !relic.isEvolved()) {
            relic.evolve(identifier, index, stack, sourceEntity);
        }
    }

    public void evolve(String identifier, int index, ItemStack stack, LivingEntity entity) {
        ItemStack evolvedParasite = ((Parasite116Item)((Object)ItemRegistry.PARASITE_116.get())).getDefaultInstance();
        Parasite116Item relic = (Parasite116Item)evolvedParasite.getItem();
        relic.setAbilityComponent(evolvedParasite, "infectious_bloom", this.getAbilityComponent(stack, "infectious_bloom"));
        relic.setLevelingComponent(evolvedParasite, this.getLevelingComponent(stack));
        for (AbilityData ability : this.getAbilitiesData().getAbilities().values()) {
            String abilityID = ability.getId();
            for (StatData stat : ability.getStats().values()) {
                String statID = stat.getId();
                int quality = this.getStatQuality(stack, abilityID, statID);
                double value = relic.getStatValueByQuality(abilityID, statID, quality);
                relic.setStatInitialValue(evolvedParasite, abilityID, statID, value);
            }
        }
        ((ICuriosItemHandler)CuriosApi.getCuriosInventory((LivingEntity)entity).get()).setEquippedCurio(identifier, index, evolvedParasite);
        entity.level().playSound(null, (Entity)entity, SoundEvents.BEACON_POWER_SELECT, SoundSource.PLAYERS, 1.0f, 0.5f);
        entity.level().playSound(null, (Entity)entity, SoundEvents.BEACON_ACTIVATE, SoundSource.PLAYERS, 1.0f, 1.5f);
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new ParasiteEvolveParticlePacket(entity.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new PacketItemActivation(evolvedParasite), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean isEvolved() {
        return false;
    }

    public String getConfigRoute() {
        return "reliquified_twilight_forest";
    }

    @SubscribeEvent
    public static void consumeExperiment115(LivingEntityUseItemEvent.Finish e) {
        if (e.getItem().is((Holder)TFItems.EXPERIMENT_115)) {
            Parasite115Item.nomnomnom(e.getEntity());
        }
    }

    public static void nomnomnom(LivingEntity entity) {
        Parasite116Item relic;
        Item item;
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)entity, (Item)((Item)ItemRegistry.PARASITE_116.get()));
        if (entity.level().isClientSide || !((item = stack.getItem()) instanceof Parasite116Item) || !(relic = (Parasite116Item)item).isAbilityUnlocked(stack, "rage_consumption")) {
            return;
        }
        int time = (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.TIME, (Object)0);
        time = (int)Mth.clamp((double)((double)time + relic.getStatValue(stack, "rage_consumption", "amount_restored")), (double)0.0, (double)200.0);
        stack.set((Supplier)DataComponentRegistry.TIME, (Object)time);
        relic.spreadRelicExperience(entity, stack, 1);
    }
}

