/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_twilight_forest.item.relic;

import it.hurts.octostudios.reliquified_twilight_forest.client.event.RenderItemInHandEvent;
import it.hurts.octostudios.reliquified_twilight_forest.data.loot.LootEntries;
import it.hurts.octostudios.reliquified_twilight_forest.init.ItemRegistry;
import it.hurts.octostudios.reliquified_twilight_forest.util.EntitiesButCool;
import it.hurts.octostudios.reliquified_twilight_forest.util.MathButCool;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;

public class GiantGloveItem
extends RelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"oversized_grip").stat(StatData.builder((String)"multiplier").initialValue(0.05, 0.15).upgradeModifier(UpgradeOperation.ADD, 0.035).formatValue(MathButCool::percentage).build()).build()).build()).leveling(LevelingData.builder().sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"oversized_grip").gem(GemShape.SQUARE, GemColor.BLUE).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.TROLL}).build()).build();
    }

    @Nullable
    public RelicAttributeModifier getRelicAttributeModifiers(ItemStack stack) {
        float multiplier = (float)this.getStatValue(stack, "oversized_grip", "multiplier");
        return RelicAttributeModifier.builder().attribute(new RelicAttributeModifier.Modifier(Attributes.BLOCK_INTERACTION_RANGE, 2.5f * (1.0f + multiplier), AttributeModifier.Operation.ADD_VALUE)).attribute(new RelicAttributeModifier.Modifier(Attributes.ENTITY_INTERACTION_RANGE, 2.5f * (1.0f + multiplier), AttributeModifier.Operation.ADD_VALUE)).build();
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        super.onUnequip(slotContext, newStack, stack);
        if (newStack.getItem() != stack.getItem()) {
            GiantGloveItem.removeAttributes(slotContext);
        }
    }

    public String getConfigRoute() {
        return "reliquified_twilight_forest";
    }

    private static void removeAttributes(SlotContext slotContext) {
        ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)"reliquified_twilight_forest", (String)("giant_glove_" + slotContext.identifier()));
        BuiltInRegistries.ATTRIBUTE.asHolderIdMap().iterator().forEachRemaining(holder -> {
            if (!slotContext.entity().getAttributes().hasAttribute(holder)) {
                return;
            }
            slotContext.entity().getAttributes().getInstance(holder).removeModifier(rl);
        });
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class ClientEvents {
        @SubscribeEvent
        public static void renderItem(RenderItemInHandEvent e) {
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)e.getEntity(), (Item)((Item)ItemRegistry.GIANT_GLOVE.get()));
            Item item = stack.getItem();
            if (!(item instanceof GiantGloveItem)) {
                return;
            }
            GiantGloveItem relic = (GiantGloveItem)item;
            if (e.getDisplayContext().firstPerson()) {
                float scale = (float)(1.25 + relic.getStatValue(stack, "oversized_grip", "multiplier") * 1.8);
                e.getPoseStack().scale(scale, scale, scale);
                e.getPoseStack().translate(0.0, -0.1, 0.0);
                if (e.getItemStack().is(Tags.Items.TOOLS_SHIELD)) {
                    e.getPoseStack().translate(0.1 * (double)(e.getDisplayContext() == ItemDisplayContext.FIRST_PERSON_LEFT_HAND ? -1 : 1), -0.2, 0.0);
                }
                return;
            }
            float scale = (float)(2.0 + relic.getStatValue(stack, "oversized_grip", "multiplier") * 6.0);
            e.getPoseStack().scale(scale, scale, scale);
            e.getPoseStack().translate(0.0f, 0.0f, -0.075f);
        }
    }

    @EventBusSubscriber
    public static class CommonEvents {
        @SubscribeEvent
        public static void entityHit(LivingDamageEvent.Post e) {
            LivingEntity source;
            GiantGloveItem relic;
            ItemStack stack;
            block3: {
                block2: {
                    Item item;
                    stack = EntityUtils.findEquippedCurio((Entity)e.getSource().getDirectEntity(), (Item)((Item)ItemRegistry.GIANT_GLOVE.get()));
                    if (e.getEntity().level().isClientSide || !((item = stack.getItem()) instanceof GiantGloveItem)) break block2;
                    relic = (GiantGloveItem)item;
                    item = e.getSource().getDirectEntity();
                    if (item instanceof LivingEntity && !(source = (LivingEntity)item).getMainHandItem().isEmpty()) break block3;
                }
                return;
            }
            relic.spreadRelicExperience(source, stack, 1);
        }

        @SubscribeEvent
        public static void blockBreak(BlockEvent.BreakEvent e) {
            GiantGloveItem relic;
            ItemStack stack;
            block3: {
                block2: {
                    Item item;
                    stack = EntityUtils.findEquippedCurio((Entity)e.getPlayer(), (Item)((Item)ItemRegistry.GIANT_GLOVE.get()));
                    if (e.getPlayer().level().isClientSide || !((item = stack.getItem()) instanceof GiantGloveItem)) break block2;
                    relic = (GiantGloveItem)item;
                    if (!(e.getState().getDestroySpeed((BlockGetter)e.getLevel(), e.getPos()) <= 0.0f) && !e.getPlayer().getMainHandItem().isEmpty()) break block3;
                }
                return;
            }
            relic.spreadRelicExperience((LivingEntity)e.getPlayer(), stack, 1);
        }

        @SubscribeEvent
        public static void playerTick(EntityTickEvent.Post e) {
            Player living;
            block3: {
                block2: {
                    Entity entity = e.getEntity();
                    if (!(entity instanceof Player)) break block2;
                    living = (Player)entity;
                    if (!living.level().isClientSide) break block3;
                }
                return;
            }
            List<SlotResult> slots = EntitiesButCool.findEquippedSlots((LivingEntity)living, (Item)ItemRegistry.GIANT_GLOVE.get());
            slots.forEach(slotResult -> {
                ItemStack stack = slotResult.stack();
                Item patt0$temp = stack.getItem();
                if (!(patt0$temp instanceof GiantGloveItem)) {
                    return;
                }
                GiantGloveItem relic = (GiantGloveItem)patt0$temp;
                ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)"reliquified_twilight_forest", (String)("giant_glove_" + slotResult.slotContext().identifier()));
                GiantGloveItem.removeAttributes(slotResult.slotContext());
                float multiplier = (float)relic.getStatValue(stack, "oversized_grip", "multiplier");
                living.getMainHandItem().getAttributeModifiers().forEach(EquipmentSlotGroup.MAINHAND, (attributeHolder, attributeModifier) -> {
                    AttributeInstance patt0$temp = living.getAttribute(attributeHolder);
                    if (!(patt0$temp instanceof AttributeInstance)) {
                        return;
                    }
                    AttributeInstance instance = patt0$temp;
                    if (instance.getBaseValue() < 0.0) {
                        instance.addOrUpdateTransientModifier(new AttributeModifier(rl, Math.abs(instance.getValue() * (double)multiplier), AttributeModifier.Operation.ADD_VALUE));
                        return;
                    }
                    instance.addOrUpdateTransientModifier(new AttributeModifier(rl, (double)multiplier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
                });
            });
        }
    }
}

