/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_lenders_cataclysm.items.relics.charm;

import it.hurts.octostudios.reliquified_lenders_cataclysm.entities.VoidVortexModifiedEntity;
import it.hurts.octostudios.reliquified_lenders_cataclysm.init.ItemRegistry;
import it.hurts.octostudios.reliquified_lenders_cataclysm.init.RECDataComponentRegistry;
import it.hurts.octostudios.reliquified_lenders_cataclysm.items.base.RECItem;
import it.hurts.octostudios.reliquified_lenders_cataclysm.items.base.data.RECLootEntries;
import it.hurts.octostudios.reliquified_lenders_cataclysm.utils.ItemUtils;
import it.hurts.octostudios.reliquified_lenders_cataclysm.utils.RECMathUtils;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootEntries;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class VoidVortexInBottleItem
extends RECItem {
    private static final String ABILITY_ID = "spawn_vortex";

    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)ABILITY_ID).stat(StatData.builder((String)"height").initialValue(3.0, 4.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.075).formatValue(RECMathUtils::roundInt).build()).stat(StatData.builder((String)"damage").initialValue(6.0, 8.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(RECMathUtils::roundDamage).build()).stat(StatData.builder((String)"cooldown").initialValue(30.0, 25.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.06).formatValue(RECMathUtils::roundOneDigit).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).step(100).maxLevel(10).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)ABILITY_ID).gem(GemShape.SQUARE, GemColor.PURPLE).build()).build()).build()).loot(LootData.builder().entry(new LootEntry[]{RECLootEntries.FROSTED_PRISON, LootEntries.THE_END}).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-6922832).borderBottom(-8960882).textured(true).build()).beams(BeamsData.builder().startColor(-9624915).endColor(10704581).build()).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity entity = slotContext.entity();
        if (stack.isEmpty()) {
            return;
        }
        Level level = entity.getCommandSenderWorld();
        if (level.isClientSide) {
            return;
        }
        int cooldownCurrent = this.getVortexCooldown(stack);
        if (cooldownCurrent > 0) {
            if (cooldownCurrent == 1) {
                ItemUtils.playCooldownSound(level, entity);
            }
            this.reduceVortexCooldown(stack);
        }
    }

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        Object object;
        Level level = event.getEntity().level();
        if (level.isClientSide || !((object = event.getSource().getEntity()) instanceof Player)) {
            return;
        }
        Player player = (Player)object;
        for (ItemStack stack : EntityUtils.findEquippedCurios((Entity)player, (Item)((Item)ItemRegistry.VOID_VORTEX_IN_BOTTLE.get()))) {
            VoidVortexInBottleItem relic;
            LivingEntity target = event.getEntity();
            Item item = stack.getItem();
            if (!(item instanceof VoidVortexInBottleItem) || (relic = (VoidVortexInBottleItem)item).getVortexCooldown(stack) > 0) continue;
            VoidVortexModifiedEntity voidVortexEntity = new VoidVortexModifiedEntity(level, target.getX(), target.getY(), target.getZ(), player.getYRot(), (LivingEntity)player, 100, ItemUtils.getIntStat(stack, ABILITY_ID, "height"), relic.getDamageStat(stack));
            voidVortexEntity.setOwner((LivingEntity)player);
            level.addFreshEntity((Entity)voidVortexEntity);
            relic.spreadRelicExperience((LivingEntity)player, stack, 3);
            relic.setVortexCooldown(stack);
        }
    }

    private float getDamageStat(ItemStack stack) {
        return (float)this.getStatValue(stack, ABILITY_ID, "damage");
    }

    private int getVortexCooldown(ItemStack stack) {
        return (Integer)stack.getOrDefault(RECDataComponentRegistry.COOLDOWN, (Object)0);
    }

    private void reduceVortexCooldown(ItemStack stack) {
        stack.set(RECDataComponentRegistry.COOLDOWN, (Object)(this.getVortexCooldown(stack) - 1));
    }

    private void setVortexCooldown(ItemStack stack) {
        stack.set(RECDataComponentRegistry.COOLDOWN, (Object)ItemUtils.getCooldownStat(stack, ABILITY_ID));
    }
}

