/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.reliquified_ars_nouveau.items.bracelet;

import it.hurts.octostudios.reliquified_ars_nouveau.entities.BallistarianBowEntity;
import it.hurts.octostudios.reliquified_ars_nouveau.entities.MagicShellEntity;
import it.hurts.octostudios.reliquified_ars_nouveau.init.EntityRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.init.ItemRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.init.RANDataComponentRegistry;
import it.hurts.octostudios.reliquified_ars_nouveau.items.NouveauRelicItem;
import it.hurts.octostudios.reliquified_ars_nouveau.items.base.loot.LootEntries;
import it.hurts.octostudios.reliquified_ars_nouveau.items.bracelet.BallistarianBracerComponent;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourceData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingSourcesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemColor;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.GemShape;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.style.BeamsData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.StyleData;
import it.hurts.sskirillss.relics.items.relics.base.data.style.TooltipData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import org.apache.commons.lang3.tuple.Pair;
import top.theillusivec4.curios.api.SlotContext;

public class BallistarianBracerItem
extends NouveauRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"striker").stat(StatData.builder((String)"damage").initialValue(2.0, 5.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).stat(StatData.builder((String)"count").initialValue(4.0, 6.0).upgradeModifier(UpgradeOperation.ADD, 0.7).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).stat(StatData.builder((String)"chance").initialValue(0.4, 0.6).upgradeModifier(UpgradeOperation.ADD, 0.02).formatValue(value -> (int)MathUtils.round((double)(value * 100.0), (int)0)).build()).stat(StatData.builder((String)"cooldown").initialValue(20.0, 15.0).upgradeModifier(UpgradeOperation.ADD, -0.01).formatValue(value -> (int)MathUtils.round((double)value, (int)0)).build()).build()).build()).leveling(LevelingData.builder().initialCost(100).maxLevel(10).step(100).sources(LevelingSourcesData.builder().source(LevelingSourceData.abilityBuilder((String)"striker").initialValue(1).gem(GemShape.SQUARE, GemColor.ORANGE).build()).build()).build()).style(StyleData.builder().tooltip(TooltipData.builder().borderTop(-2251484).borderBottom(-2251484).textured(true).build()).beams(BeamsData.builder().startColor(-1100904).endColor(12784992).build()).build()).loot(LootData.builder().entry(new LootEntry[]{LootEntries.ARS_NOUVEAU, LootEntries.ARS_NOUVEAU_LIKE}).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).getCommandSenderWorld().isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)player.getCommandSenderWorld();
        ArrayList<BallistarianBracerComponent> entities = new ArrayList<BallistarianBracerComponent>(this.getBallistarianList(stack));
        int index = entities.size();
        int maxCount = (int)Math.round(this.getStatValue(stack, "striker", "count"));
        if (entities.size() < maxCount) {
            Vec3 normalizedLookAngle = player.getLookAngle().normalize();
            BallistarianBowEntity bow = new BallistarianBowEntity((EntityType<? extends Mob>)((EntityType)EntityRegistry.BALLISTARIAN_BOW.value()), (Level)level);
            Pair<Vec3, Double> pair = bow.calculateOffsetAndHeight(index, maxCount, normalizedLookAngle);
            Vec3 offset = (Vec3)pair.getLeft();
            Vec3 spawnPos = player.position().add(offset.x, player.getEyeY() - player.getY() + (Double)pair.getRight(), offset.z);
            bow.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
            bow.setOwnerUUID(player.getUUID());
            bow.rotatedBowAngle(normalizedLookAngle, maxCount, index);
            level.addFreshEntity((Entity)bow);
            this.addEntity(stack, bow.getUUID());
        } else {
            this.setBallistarianList(stack, this.getBallistarianList(stack).stream().map(component -> {
                if (component.cooldown() > 0) {
                    return new BallistarianBracerComponent(component.uuid(), component.cooldown() - 1);
                }
                return component;
            }).collect(Collectors.toList()));
        }
        if (!entities.isEmpty()) {
            for (int i = entities.size() - 1; i >= 0; --i) {
                String uuid = entities.get(i).uuid();
                Entity bow = level.getEntity(UUID.fromString(uuid));
                if (bow != null || this.getCooldown(stack, UUID.fromString(uuid)) != 0) continue;
                this.removeEntity(stack, uuid);
            }
        }
    }

    public void addEntity(ItemStack stack, UUID uuid) {
        ArrayList<BallistarianBracerComponent> list = new ArrayList<BallistarianBracerComponent>(this.getBallistarianList(stack));
        list.add(new BallistarianBracerComponent(uuid.toString(), 0));
        this.setBallistarianList(stack, list);
    }

    public void removeEntity(ItemStack stack, String uuid) {
        ArrayList<BallistarianBracerComponent> list = new ArrayList<BallistarianBracerComponent>(this.getBallistarianList(stack));
        list.removeIf(component -> component.uuid().equals(uuid));
        this.setBallistarianList(stack, list);
    }

    public void setCooldown(ItemStack stack, String uuid, int cooldown) {
        ArrayList<BallistarianBracerComponent> list = new ArrayList<BallistarianBracerComponent>();
        for (BallistarianBracerComponent comp : this.getBallistarianList(stack)) {
            if (comp.uuid().equals(uuid)) {
                list.add(new BallistarianBracerComponent(comp.uuid(), Math.max(0, cooldown)));
                continue;
            }
            list.add(comp);
        }
        this.setBallistarianList(stack, list);
    }

    public List<UUID> getUUIDListFromComponents(ItemStack stack) {
        return this.getBallistarianList(stack).stream().map(BallistarianBracerComponent::uuid).filter(Objects::nonNull).map(UUID::fromString).toList();
    }

    public int getCooldown(ItemStack stack, UUID uuid) {
        return this.getBallistarianList(stack).stream().filter(comp -> comp.uuid().equals(uuid.toString())).map(BallistarianBracerComponent::cooldown).findFirst().orElse(0);
    }

    public void setBallistarianList(ItemStack stack, List<BallistarianBracerComponent> list) {
        stack.set(RANDataComponentRegistry.BALLISTARIAN_LIST, list);
    }

    public List<BallistarianBracerComponent> getBallistarianList(ItemStack stack) {
        return (List)stack.getOrDefault(RANDataComponentRegistry.BALLISTARIAN_LIST, new ArrayList());
    }

    @EventBusSubscriber
    public static class BallistarianBracerEvent {
        @SubscribeEvent
        public static void onProjectileImpactEvent(ProjectileImpactEvent event) {
            Projectile projectile = event.getProjectile();
            Level level = projectile.getCommandSenderWorld();
            Entity entity = projectile.getOwner();
            if (!(entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ItemRegistry.BALLISTARIAN_BRACER.value()));
            Item item = stack.getItem();
            if (!(item instanceof BallistarianBracerItem)) {
                return;
            }
            BallistarianBracerItem relic = (BallistarianBracerItem)item;
            HitResult hitResult = event.getRayTraceResult();
            if (hitResult instanceof EntityHitResult) {
                Object shell;
                EntityHitResult entityHitResult = (EntityHitResult)hitResult;
                Projectile projectile2 = event.getProjectile();
                if (projectile2 instanceof MagicShellEntity && (shell = (MagicShellEntity)projectile2).getOwner() != null && shell.getOwner().getUUID().equals(entityHitResult.getEntity().getUUID())) {
                    event.setCanceled(true);
                    return;
                }
                if (entityHitResult.getEntity() instanceof BallistarianBowEntity) {
                    event.setCanceled(true);
                    return;
                }
            }
            if (level.isClientSide || !projectile.getPersistentData().contains("ShellUUIDs")) {
                return;
            }
            ArrayList<UUID> shellUuids = new ArrayList<UUID>();
            for (Tag tag : projectile.getPersistentData().getList("ShellUUIDs", 10)) {
                if (!(tag instanceof CompoundTag)) continue;
                CompoundTag compoundTag = (CompoundTag)tag;
                shellUuids.add(new UUID(compoundTag.getLong("MostSigBits"), compoundTag.getLong("LeastSigBits")));
            }
            HitResult hitResult2 = event.getRayTraceResult();
            Vec3 position = hitResult2.getLocation();
            for (UUID uuid : shellUuids) {
                Entity shell = ((ServerLevel)level).getEntity(uuid);
                if (shell == null || !shell.isAlive()) continue;
                CompoundTag shellPersistentData = shell.getPersistentData();
                shellPersistentData.remove("TargetUUID");
                if (hitResult2 instanceof EntityHitResult) {
                    EntityHitResult entityHitResult = (EntityHitResult)hitResult2;
                    relic.spreadRelicExperience((LivingEntity)player, stack, 1);
                    shellPersistentData.putUUID("HitEntity", entityHitResult.getEntity().getUUID());
                    continue;
                }
                shellPersistentData.putDouble("HitPosX", position.x);
                shellPersistentData.putDouble("HitPosY", position.y);
                shellPersistentData.putDouble("HitPosZ", position.z);
            }
        }
    }
}

