/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.misc;

import it.hurts.sskirillss.relics.client.screen.description.general.misc.DescriptionTab;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class DescriptionCache {
    private static final Map<IRelicItem, CacheEntry> CACHE = new HashMap<IRelicItem, CacheEntry>();

    public static CacheEntry getEntry(IRelicItem relic) {
        return CACHE.computeIfAbsent(relic, entry -> new CacheEntry());
    }

    public static void setEntry(IRelicItem relic, CacheEntry cache) {
        CACHE.put(relic, cache);
    }

    public static String getSelectedAbility(ItemStack stack) {
        String ability;
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return "";
        }
        IRelicItem relic = (IRelicItem)item;
        CacheEntry cache = DescriptionCache.getEntry(relic);
        int index = cache.getSelectionIndex(DescriptionTab.ABILITY);
        List<String> abilities = relic.getAbilitiesData().getAbilities().keySet().stream().filter(entry -> relic.isAbilityEnabled(stack, (String)entry)).toList();
        int size = abilities.size();
        if (size == 0) {
            return "";
        }
        if (index >= size) {
            index = size - 1;
        }
        if ((ability = abilities.get(index)) == null) {
            index = 0;
            ability = abilities.get(index);
            DescriptionCache.setEntry(relic, cache.toBuilder().selectionIndex(DescriptionTab.ABILITY, index).build());
        }
        return ability;
    }

    public static void setSelectedAbility(ItemStack stack, String ability) {
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        CacheEntry cache = DescriptionCache.getEntry(relic);
        List<String> abilities = relic.getAbilitiesData().getAbilities().keySet().stream().filter(entry -> relic.isAbilityEnabled(stack, (String)entry)).toList();
        if (!abilities.contains(ability)) {
            return;
        }
        int index = abilities.indexOf(ability);
        DescriptionCache.setEntry(relic, cache.toBuilder().selectionIndex(DescriptionTab.ABILITY, index).build());
    }

    public static String getSelectedExperienceSource(ItemStack stack) {
        String source;
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return "";
        }
        IRelicItem relic = (IRelicItem)item;
        CacheEntry cache = DescriptionCache.getEntry(relic);
        int index = cache.getSelectionIndex(DescriptionTab.EXPERIENCE);
        List<String> sources = relic.getLevelingSourcesData().getSources().keySet().stream().filter(entry -> relic.isLevelingSourceEnabled(stack, (String)entry)).toList();
        int size = sources.size();
        if (size == 0) {
            return "";
        }
        if (index >= size) {
            index = size - 1;
        }
        if ((source = sources.get(index)) == null) {
            index = 0;
            source = sources.get(index);
            DescriptionCache.setEntry(relic, cache.toBuilder().selectionIndex(DescriptionTab.EXPERIENCE, index).build());
        }
        return source;
    }

    public static void setSelectedExperienceSource(ItemStack stack, String source) {
        Item item = stack.getItem();
        if (!(item instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        CacheEntry cache = DescriptionCache.getEntry(relic);
        List<String> sources = relic.getLevelingSourcesData().getSources().keySet().stream().filter(entry -> relic.isLevelingSourceEnabled(stack, (String)entry)).toList();
        if (!sources.contains(source)) {
            return;
        }
        int index = sources.indexOf(source);
        DescriptionCache.setEntry(relic, cache.toBuilder().selectionIndex(DescriptionTab.EXPERIENCE, index).build());
    }

    public static class CacheEntry {
        private DescriptionTab selectedPage = DescriptionTab.RELIC;
        private Map<DescriptionTab, Integer> selectionIndices = new HashMap<DescriptionTab, Integer>(this){
            final /* synthetic */ CacheEntry this$0;
            {
                this.this$0 = this$0;
                for (DescriptionTab page : DescriptionTab.values()) {
                    this.put(page, 0);
                }
            }
        };

        public int getSelectionIndex(DescriptionTab page) {
            return this.selectionIndices.computeIfAbsent(page, entry -> 0);
        }

        public static CacheEntryBuilder builder() {
            return new CacheEntryBuilder();
        }

        public CacheEntryBuilder toBuilder() {
            return new CacheEntryBuilder().selectedPage(this.selectedPage).selectionIndices(this.selectionIndices);
        }

        public CacheEntry() {
        }

        public CacheEntry(DescriptionTab selectedPage, Map<DescriptionTab, Integer> selectionIndices) {
            this.selectedPage = selectedPage;
            this.selectionIndices = selectionIndices;
        }

        public DescriptionTab getSelectedPage() {
            return this.selectedPage;
        }

        public static class CacheEntryBuilder {
            private DescriptionTab selectedPage;
            private Map<DescriptionTab, Integer> selectionIndices;

            public CacheEntryBuilder selectionIndex(DescriptionTab page, int index) {
                this.selectionIndices.put(page, index);
                return this;
            }

            CacheEntryBuilder() {
            }

            public CacheEntryBuilder selectedPage(DescriptionTab selectedPage) {
                this.selectedPage = selectedPage;
                return this;
            }

            public CacheEntryBuilder selectionIndices(Map<DescriptionTab, Integer> selectionIndices) {
                this.selectionIndices = selectionIndices;
                return this;
            }

            public CacheEntry build() {
                return new CacheEntry(this.selectedPage, this.selectionIndices);
            }

            public String toString() {
                return "DescriptionCache.CacheEntry.CacheEntryBuilder(selectedPage=" + String.valueOf((Object)this.selectedPage) + ", selectionIndices=" + String.valueOf(this.selectionIndices) + ")";
            }
        }
    }
}

