/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.blocks;

import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.feet.PhantomBootItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PhantomBlock
extends Block {
    public PhantomBlock() {
        super(BlockBehaviour.Properties.of().friction(0.98f).sound(SoundType.WOOL).dynamicShape().noOcclusion().instabreak());
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        level.scheduleTick(pos, (Block)this, Mth.nextInt((RandomSource)level.getRandom(), (int)80, (int)120));
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
        level.playSound(null, pos, SoundEvents.CANDLE_EXTINGUISH, SoundSource.MASTER, 1.0f, 2.0f);
        level.sendParticles(ParticleUtils.constructSimpleSpark(new Color(100 + random.nextInt(100), 0, 200 + random.nextInt(50)), 0.1f + random.nextFloat() * 0.2f, 40, 0.9f), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), 25, 0.5, 0.5, 0.5, (double)0.05f);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        entity.causeFallDamage(fallDistance, 0.0f, level.damageSources().fall());
        level.playSound(null, pos, SoundEvents.PHANTOM_FLAP, SoundSource.MASTER, 1.0f, 2.0f);
        RandomSource random = level.getRandom();
        double speed = Math.abs(entity.getDeltaMovement().y());
        int i = 0;
        while ((double)i < speed * 75.0) {
            level.addParticle(ParticleUtils.constructSimpleSpark(new Color(100 + random.nextInt(100), 0, 200 + random.nextInt(50)), 0.1f + random.nextFloat() * 0.2f, 40 + random.nextInt(40), 0.95f), entity.getX() + (double)MathUtils.randomFloat(random) * speed, entity.getY(), entity.getZ() + (double)MathUtils.randomFloat(random) * speed, 0.0, (double)0.05f + speed * (double)random.nextFloat() * 0.25, 0.0);
            ++i;
        }
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (!level.isClientSide()) {
            return;
        }
        RandomSource random = level.getRandom();
        Vec3 motion = entity.getDeltaMovement();
        double speed = motion.multiply(1.0, 0.0, 1.0).length();
        float width = entity.getBbWidth();
        float i = 0.0f;
        while ((double)i < speed) {
            level.addParticle(ParticleUtils.constructSimpleSpark(new Color(100 + random.nextInt(100), 0, 200 + random.nextInt(50)), 0.2f + random.nextFloat() * 0.25f, 10 + random.nextInt(20), 0.9f), entity.getX() + (double)(MathUtils.randomFloat(random) * width), entity.getY(), entity.getZ() + (double)(MathUtils.randomFloat(random) * width), -motion.x(), 0.0, -motion.z());
            i += 0.05f;
        }
    }

    public void updateEntityAfterFallOn(BlockGetter level, Entity entity) {
        Vec3 motion = entity.getDeltaMovement();
        if (motion.y > -0.5) {
            super.updateEntityAfterFallOn(level, entity);
            return;
        }
        entity.setDeltaMovement(motion.x, -(motion.y / 1.5), motion.z);
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        VoxelShape shape;
        PhantomBootItem relic;
        Item item;
        if (!(context instanceof EntityCollisionContext)) {
            return Shapes.empty();
        }
        EntityCollisionContext entityContext = (EntityCollisionContext)context;
        Entity entity = entityContext.getEntity();
        if (entity == null) {
            return Shapes.empty();
        }
        ItemStack stack = EntityUtils.findEquippedCurio(entity, (Item)ItemRegistry.PHANTOM_BOOT.get());
        if (!entity.isShiftKeyDown() && !stack.isEmpty() && (item = stack.getItem()) instanceof PhantomBootItem && (relic = (PhantomBootItem)item).isToggled(stack) && entityContext.isAbove(shape = Shapes.block(), pos, true)) {
            return shape;
        }
        return Shapes.empty();
    }
}

