/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.util;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerListener {
    @Nullable
    private static ExecutorService autocraftingPool;
    private static final int AUTOCRAFTING_POOL_SIZE = 4;
    private static final int AUTOCRAFTING_MAX_QUEUED_REQUESTS = 2;
    private static final Logger LOGGER;
    private static final Deque<Consumer<MinecraftServer>> ACTIONS;

    private ServerListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tick(MinecraftServer server) {
        Deque<Consumer<MinecraftServer>> deque = ACTIONS;
        synchronized (deque) {
            Consumer<MinecraftServer> action;
            while ((action = ACTIONS.poll()) != null) {
                action.accept(server);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queue(Consumer<MinecraftServer> runnable) {
        Deque<Consumer<MinecraftServer>> deque = ACTIONS;
        synchronized (deque) {
            ACTIONS.add(runnable);
        }
    }

    private static ExecutorService createAutocraftingPool() {
        return new ThreadPoolExecutor(4, 4, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(2), (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("refinedstorage-autocrafting-%d").build(), new ThreadPoolExecutor.AbortPolicy());
    }

    public static ExecutorService getAutocraftingPool() {
        return Objects.requireNonNull(autocraftingPool, "Autocrafting pool is not initialized");
    }

    public static void starting() {
        if (autocraftingPool != null) {
            LOGGER.debug("Previous autocrafting pool is still active, stopping");
            ServerListener.stopPool(autocraftingPool);
            autocraftingPool = null;
        }
        LOGGER.debug("Creating new autocrafting pool");
        autocraftingPool = ServerListener.createAutocraftingPool();
    }

    public static void stopped() {
        if (autocraftingPool != null) {
            LOGGER.debug("Stopping autocrafting pool");
            ServerListener.stopPool(autocraftingPool);
            autocraftingPool = null;
        } else {
            LOGGER.debug("There was no autocrafting pool to stop?");
        }
    }

    private static void stopPool(ExecutorService pool) {
        pool.shutdown();
        try {
            if (!pool.awaitTermination(800L, TimeUnit.MILLISECONDS)) {
                LOGGER.warn("Autocrafting pool did not terminate in time, forcing shutdown");
                pool.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted while waiting for autocrafting pool to terminate", (Throwable)e);
            pool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(ServerListener.class);
        ACTIONS = new ArrayDeque<Consumer<MinecraftServer>>();
    }
}

