/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storage.portablegrid;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.energy.EnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.energy.AbstractProxyEnergyStorage;
import com.refinedmods.refinedstorage.api.network.impl.energy.EnergyStorageImpl;
import com.refinedmods.refinedstorage.api.storage.StateTrackedStorage;
import com.refinedmods.refinedstorage.api.storage.StorageState;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.StorageContainerItem;
import com.refinedmods.refinedstorage.common.api.storage.StorageRepository;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.api.support.energy.AbstractEnergyBlockItem;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReferenceHandlerItem;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.storage.Disk;
import com.refinedmods.refinedstorage.common.storage.DiskInventory;
import com.refinedmods.refinedstorage.common.storage.portablegrid.AbstractPortableGridBlockEntity;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGrid;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridBlockItemRenderInfo;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridItemExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.storage.portablegrid.PortableGridType;
import com.refinedmods.refinedstorage.common.support.energy.CreativeEnergyStorage;
import com.refinedmods.refinedstorage.common.support.energy.ItemBlockEnergyStorage;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class PortableGridBlockItem
extends AbstractEnergyBlockItem
implements SlotReferenceHandlerItem {
    private static final Component HELP = IdentifierUtil.createTranslation("item", "portable_grid.help");
    private final PortableGridType type;

    public PortableGridBlockItem(Block block, PortableGridType type) {
        super(block, new Item.Properties().stacksTo(1), RefinedStorageApi.INSTANCE.getEnergyItemHelper());
        this.type = type;
    }

    public static PortableGridBlockItemRenderInfo getRenderInfo(ItemStack stack, Level level) {
        boolean creative = PortableGridBlockItem.isCreative(stack);
        boolean hasEnergy = creative || PortableGridBlockItem.createEnergyStorage(stack).getStored() > 0L;
        ItemStack diskStack = PortableGridBlockItem.getDisk(stack, (HolderLookup.Provider)level.registryAccess());
        boolean active = hasEnergy && !diskStack.isEmpty();
        Disk disk = new Disk(diskStack.isEmpty() ? null : diskStack.getItem(), PortableGridBlockItem.getState(diskStack, active));
        return new PortableGridBlockItemRenderInfo(active, disk);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isCreative(ItemStack stack) {
        Item item = stack.getItem();
        if (!(item instanceof PortableGridBlockItem)) return false;
        PortableGridBlockItem portableGridBlockItem = (PortableGridBlockItem)item;
        if (portableGridBlockItem.type != PortableGridType.CREATIVE) return false;
        return true;
    }

    private static StorageState getState(ItemStack diskStack, boolean active) {
        Item item;
        if (diskStack.isEmpty() || !((item = diskStack.getItem()) instanceof StorageContainerItem)) {
            return StorageState.NONE;
        }
        StorageContainerItem storageContainerItem = (StorageContainerItem)item;
        if (!active) {
            return StorageState.INACTIVE;
        }
        StorageRepository storageRepository = RefinedStorageApi.INSTANCE.getClientStorageRepository();
        return storageContainerItem.getInfo(storageRepository, diskStack).map(storageInfo -> StateTrackedStorage.computeState(storageInfo.capacity(), storageInfo.stored())).orElse(StorageState.INACTIVE);
    }

    private static ItemStack getDisk(ItemStack stack, HolderLookup.Provider provider) {
        CustomData blockEntityData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (blockEntityData == null) {
            return ItemStack.EMPTY;
        }
        return AbstractPortableGridBlockEntity.getDisk(blockEntityData, provider);
    }

    static void setDiskInventory(ItemStack stack, DiskInventory diskInventory, HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        AbstractPortableGridBlockEntity.writeDiskInventory(tag, diskInventory, provider);
        ItemBlockEnergyStorage.writeToTag(tag, PortableGridBlockItem.createEnergyStorage(stack).getStored());
        PortableGridBlockItem.setBlockEntityData((ItemStack)stack, PortableGridBlockItem.isCreative(stack) ? BlockEntities.INSTANCE.getCreativePortableGrid() : BlockEntities.INSTANCE.getPortableGrid(), (CompoundTag)tag);
    }

    public static EnergyStorage createEnergyStorage(ItemStack stack) {
        EnergyStorageImpl energyStorage = new EnergyStorageImpl(Platform.INSTANCE.getConfig().getPortableGrid().getEnergyCapacity());
        return RefinedStorageApi.INSTANCE.asBlockItemEnergyStorage(energyStorage, stack, BlockEntities.INSTANCE.getPortableGrid());
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        if (player.isCrouching()) {
            return super.useOn(context);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            SlotReference slotReference = RefinedStorageApi.INSTANCE.createInventorySlotReference(player, context.getHand());
            slotReference.resolve(player).ifPresent(s -> this.use(serverPlayer, (ItemStack)s, slotReference));
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (level.getServer() != null) {
                SlotReference slotReference = RefinedStorageApi.INSTANCE.createInventorySlotReference(player, hand);
                slotReference.resolve(player).ifPresent(s -> this.use(serverPlayer, (ItemStack)s, slotReference));
            }
        }
        return InteractionResultHolder.consume((Object)stack);
    }

    @Override
    public void use(ServerPlayer player, ItemStack stack, SlotReference slotReference) {
        PortableGrid portableGrid;
        PortableGridEnergyStorage energyStorage = this.createEnergyStorageInternal(stack);
        ServerLevel level = player.serverLevel();
        DiskInventoryListenerImpl listener = new DiskInventoryListenerImpl(stack, (HolderLookup.Provider)level.registryAccess());
        DiskInventory diskInventory = this.createDiskInventory(stack, listener, (HolderLookup.Provider)level.registryAccess());
        diskInventory.setStorageRepository(RefinedStorageApi.INSTANCE.getStorageRepository((Level)level));
        listener.portableGrid = portableGrid = new PortableGrid(energyStorage, diskInventory, () -> {});
        energyStorage.portableGrid = portableGrid;
        portableGrid.updateStorage();
        Platform.INSTANCE.getMenuOpener().openMenu(player, new PortableGridItemExtendedMenuProvider((Component)Objects.requireNonNullElse((Component)stack.get(DataComponents.CUSTOM_NAME), this.type == PortableGridType.CREATIVE ? ContentNames.CREATIVE_PORTABLE_GRID : ContentNames.PORTABLE_GRID), portableGrid, energyStorage, diskInventory, slotReference));
    }

    private PortableGridEnergyStorage createEnergyStorageInternal(ItemStack stack) {
        if (this.type == PortableGridType.CREATIVE) {
            return new PortableGridEnergyStorage(CreativeEnergyStorage.INSTANCE);
        }
        return new PortableGridEnergyStorage(PortableGridBlockItem.createEnergyStorage(stack));
    }

    private DiskInventory createDiskInventory(ItemStack stack, DiskInventoryListenerImpl listener, HolderLookup.Provider provider) {
        DiskInventory diskInventory = new DiskInventory(listener, 1);
        CustomData customData = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        if (customData != null) {
            AbstractPortableGridBlockEntity.readDiskInventory(customData.copyTag(), diskInventory, provider);
        }
        return diskInventory;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return Optional.of(new HelpTooltipComponent(HELP));
    }

    private static class PortableGridEnergyStorage
    extends AbstractProxyEnergyStorage {
        @Nullable
        private PortableGrid portableGrid;

        private PortableGridEnergyStorage(EnergyStorage energyStorage) {
            super(energyStorage);
        }

        @Override
        public long extract(long amount, Action action) {
            if (action == Action.EXECUTE && this.portableGrid != null) {
                boolean wasActive = this.portableGrid.isGridActive();
                long extracted = super.extract(amount, action);
                boolean isActive = this.portableGrid.isGridActive();
                if (wasActive != isActive) {
                    this.portableGrid.activeChanged(isActive);
                }
                return extracted;
            }
            return super.extract(amount, action);
        }
    }

    private static class DiskInventoryListenerImpl
    implements DiskInventory.DiskListener {
        private final ItemStack portableGridStack;
        private final HolderLookup.Provider provider;
        @Nullable
        private PortableGrid portableGrid;

        private DiskInventoryListenerImpl(ItemStack portableGridStack, HolderLookup.Provider provider) {
            this.portableGridStack = portableGridStack;
            this.provider = provider;
        }

        @Override
        public void onDiskChanged(DiskInventory inventory, int slot) {
            boolean stillLoading;
            boolean bl = stillLoading = this.portableGrid == null;
            if (stillLoading) {
                return;
            }
            PortableGridBlockItem.setDiskInventory(this.portableGridStack, inventory, this.provider);
            boolean wasActive = this.portableGrid.isGridActive();
            this.portableGrid.updateStorage();
            boolean isActive = this.portableGrid.isGridActive();
            if (wasActive != isActive) {
                this.portableGrid.activeChanged(isActive);
            }
        }
    }
}

