/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.constructordestructor;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.filter.Filter;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.api.constructordestructor.DestructorStrategy;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

class ItemPickupDestructorStrategy
implements DestructorStrategy {
    private final ServerLevel level;
    private final BlockPos pos;

    ItemPickupDestructorStrategy(ServerLevel level, BlockPos pos) {
        this.level = level;
        this.pos = pos;
    }

    @Override
    public boolean apply(Filter filter, Actor actor, Supplier<Network> networkProvider, Player player) {
        if (!this.level.isLoaded(this.pos)) {
            return false;
        }
        RootStorage rootStorage = networkProvider.get().getComponent(StorageNetworkComponent.class);
        List items = this.level.getEntitiesOfClass(ItemEntity.class, new AABB(this.pos));
        for (ItemEntity itemEntity : items) {
            this.tryInsert(filter, actor, rootStorage, itemEntity);
        }
        return true;
    }

    private void tryInsert(Filter filter, Actor actor, RootStorage rootStorage, ItemEntity itemEntity) {
        if (itemEntity.isRemoved()) {
            return;
        }
        ItemStack itemStack = itemEntity.getItem();
        ItemResource itemResource = ItemResource.ofItemStack(itemStack);
        if (!filter.isAllowed(itemResource)) {
            return;
        }
        int amount = itemStack.getCount();
        long inserted = rootStorage.insert(itemResource, amount, Action.EXECUTE, actor);
        itemStack.shrink((int)inserted);
        if (itemStack.isEmpty()) {
            itemEntity.discard();
        }
    }
}

