/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.mekanism.grid;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.grid.GridInsertionHint;
import com.refinedmods.refinedstorage.common.support.tooltip.MouseClientTooltipComponent;
import com.refinedmods.refinedstorage.mekanism.ChemicalResource;
import com.refinedmods.refinedstorage.mekanism.ChemicalUtil;
import java.util.Optional;
import mekanism.api.Action;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.item.ItemStack;

public class ChemicalGridInsertionHint
implements GridInsertionHint {
    public Optional<ClientTooltipComponent> getHint(ItemStack stack) {
        return Optional.ofNullable((IChemicalHandler)stack.getCapability(ChemicalUtil.ITEM_CAPABILITY)).map(handler -> handler.extractChemical(Long.MAX_VALUE, Action.SIMULATE)).filter(result -> !result.isEmpty()).map(this::createComponent);
    }

    private ClientTooltipComponent createComponent(ChemicalStack result) {
        ChemicalResource chemicalResource = ChemicalResource.ofChemicalStack(result);
        String amount = result.getAmount() == Platform.INSTANCE.getBucketAmount() ? null : ChemicalGridInsertionHint.doFormat(result);
        return MouseClientTooltipComponent.resource((MouseClientTooltipComponent.Type)MouseClientTooltipComponent.Type.RIGHT, (ResourceKey)chemicalResource, (String)amount);
    }

    private static String doFormat(ChemicalStack result) {
        return RefinedStorageClientApi.INSTANCE.getResourceRendering(ChemicalResource.class).formatAmount(result.getAmount());
    }
}

